import { deepEqual } from "./polyfills/polyfill_util.js";
export function enforce(condition, errMsg) {
	if (!condition) throw new Error(errMsg);
}
export function assert_nothrow(_condition, _errMsg) {}
export function enforce_nonnull(t, what) {
	if (null == t)
		throw new Error(
			`${what ?? "Given value"} should have been non-nullish, but is ${t}`,
		);
	return t;
}
export function enforce_eq(x, y) {
	if (!deepEqual(x, y))
		throw new Error(
			`LHS is ${JSON.stringify(x)}, differs from RHS ${JSON.stringify(y)}`,
		);
}
export function unreachable(msg) {
	throw new Error(
		"This point should have been unreachable" + (msg ? `: ${msg}` : ""),
	);
}
