export function staticArray1TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => [tc.lift(raw_elems[0], backing_store)],
		lower: (elems, backing_store) => [tc.lower(elems[0], backing_store)],
	};
}
export function staticWritableArray1TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => {
			if (Array.isArray(raw_elems))
				return [tc.lift(raw_elems[0], backing_store)];
			{
				const ret = {};
				for (const i in raw_elems)
					ret[i] = tc.lift(raw_elems[i], backing_store);
				return ret;
			}
		},
		lower: (elems, backing_store) => {
			if (Array.isArray(elems)) return [tc.lower(elems[0], backing_store)];
			{
				const ret = {};
				for (const i in elems) ret[i] = tc.lower(elems[i], backing_store);
				return ret;
			}
		},
	};
}
export function staticArray2TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => [
			tc.lift(raw_elems[0], backing_store),
			tc.lift(raw_elems[1], backing_store),
		],
		lower: (elems, backing_store) => [
			tc.lower(elems[0], backing_store),
			tc.lower(elems[1], backing_store),
		],
	};
}
export function staticWritableArray2TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => {
			if (Array.isArray(raw_elems))
				return [
					tc.lift(raw_elems[0], backing_store),
					tc.lift(raw_elems[1], backing_store),
				];
			{
				const ret = {};
				for (const i in raw_elems)
					ret[i] = tc.lift(raw_elems[i], backing_store);
				return ret;
			}
		},
		lower: (elems, backing_store) => {
			if (Array.isArray(elems))
				return [
					tc.lower(elems[0], backing_store),
					tc.lower(elems[1], backing_store),
				];
			{
				const ret = {};
				for (const i in elems) ret[i] = tc.lower(elems[i], backing_store);
				return ret;
			}
		},
	};
}
export function staticArray3TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => [
			tc.lift(raw_elems[0], backing_store),
			tc.lift(raw_elems[1], backing_store),
			tc.lift(raw_elems[2], backing_store),
		],
		lower: (elems, backing_store) => [
			tc.lower(elems[0], backing_store),
			tc.lower(elems[1], backing_store),
			tc.lower(elems[2], backing_store),
		],
	};
}
export function staticWritableArray3TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => {
			if (Array.isArray(raw_elems))
				return [
					tc.lift(raw_elems[0], backing_store),
					tc.lift(raw_elems[1], backing_store),
					tc.lift(raw_elems[2], backing_store),
				];
			{
				const ret = {};
				for (const i in raw_elems)
					ret[i] = tc.lift(raw_elems[i], backing_store);
				return ret;
			}
		},
		lower: (elems, backing_store) => {
			if (Array.isArray(elems))
				return [
					tc.lower(elems[0], backing_store),
					tc.lower(elems[1], backing_store),
					tc.lower(elems[2], backing_store),
				];
			{
				const ret = {};
				for (const i in elems) ret[i] = tc.lower(elems[i], backing_store);
				return ret;
			}
		},
	};
}
export function staticArray4TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => [
			tc.lift(raw_elems[0], backing_store),
			tc.lift(raw_elems[1], backing_store),
			tc.lift(raw_elems[2], backing_store),
			tc.lift(raw_elems[3], backing_store),
		],
		lower: (elems, backing_store) => [
			tc.lower(elems[0], backing_store),
			tc.lower(elems[1], backing_store),
			tc.lower(elems[2], backing_store),
			tc.lower(elems[3], backing_store),
		],
	};
}
export function staticWritableArray4TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => {
			if (Array.isArray(raw_elems))
				return [
					tc.lift(raw_elems[0], backing_store),
					tc.lift(raw_elems[1], backing_store),
					tc.lift(raw_elems[2], backing_store),
					tc.lift(raw_elems[3], backing_store),
				];
			{
				const ret = {};
				for (const i in raw_elems)
					ret[i] = tc.lift(raw_elems[i], backing_store);
				return ret;
			}
		},
		lower: (elems, backing_store) => {
			if (Array.isArray(elems))
				return [
					tc.lower(elems[0], backing_store),
					tc.lower(elems[1], backing_store),
					tc.lower(elems[2], backing_store),
					tc.lower(elems[3], backing_store),
				];
			{
				const ret = {};
				for (const i in elems) ret[i] = tc.lower(elems[i], backing_store);
				return ret;
			}
		},
	};
}
export function staticArray16TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => [
			tc.lift(raw_elems[0], backing_store),
			tc.lift(raw_elems[1], backing_store),
			tc.lift(raw_elems[2], backing_store),
			tc.lift(raw_elems[3], backing_store),
			tc.lift(raw_elems[4], backing_store),
			tc.lift(raw_elems[5], backing_store),
			tc.lift(raw_elems[6], backing_store),
			tc.lift(raw_elems[7], backing_store),
			tc.lift(raw_elems[8], backing_store),
			tc.lift(raw_elems[9], backing_store),
			tc.lift(raw_elems[10], backing_store),
			tc.lift(raw_elems[11], backing_store),
			tc.lift(raw_elems[12], backing_store),
			tc.lift(raw_elems[13], backing_store),
			tc.lift(raw_elems[14], backing_store),
			tc.lift(raw_elems[15], backing_store),
		],
		lower: (elems, backing_store) => [
			tc.lower(elems[0], backing_store),
			tc.lower(elems[1], backing_store),
			tc.lower(elems[2], backing_store),
			tc.lower(elems[3], backing_store),
			tc.lower(elems[4], backing_store),
			tc.lower(elems[5], backing_store),
			tc.lower(elems[6], backing_store),
			tc.lower(elems[7], backing_store),
			tc.lower(elems[8], backing_store),
			tc.lower(elems[9], backing_store),
			tc.lower(elems[10], backing_store),
			tc.lower(elems[11], backing_store),
			tc.lower(elems[12], backing_store),
			tc.lower(elems[13], backing_store),
			tc.lower(elems[14], backing_store),
			tc.lower(elems[15], backing_store),
		],
	};
}
export function staticWritableArray16TypeConverter(tc) {
	return {
		lift: (raw_elems, backing_store) => {
			if (Array.isArray(raw_elems))
				return [
					tc.lift(raw_elems[0], backing_store),
					tc.lift(raw_elems[1], backing_store),
					tc.lift(raw_elems[2], backing_store),
					tc.lift(raw_elems[3], backing_store),
					tc.lift(raw_elems[4], backing_store),
					tc.lift(raw_elems[5], backing_store),
					tc.lift(raw_elems[6], backing_store),
					tc.lift(raw_elems[7], backing_store),
					tc.lift(raw_elems[8], backing_store),
					tc.lift(raw_elems[9], backing_store),
					tc.lift(raw_elems[10], backing_store),
					tc.lift(raw_elems[11], backing_store),
					tc.lift(raw_elems[12], backing_store),
					tc.lift(raw_elems[13], backing_store),
					tc.lift(raw_elems[14], backing_store),
					tc.lift(raw_elems[15], backing_store),
				];
			{
				const ret = {};
				for (const i in raw_elems)
					ret[i] = tc.lift(raw_elems[i], backing_store);
				return ret;
			}
		},
		lower: (elems, backing_store) => {
			if (Array.isArray(elems))
				return [
					tc.lower(elems[0], backing_store),
					tc.lower(elems[1], backing_store),
					tc.lower(elems[2], backing_store),
					tc.lower(elems[3], backing_store),
					tc.lower(elems[4], backing_store),
					tc.lower(elems[5], backing_store),
					tc.lower(elems[6], backing_store),
					tc.lower(elems[7], backing_store),
					tc.lower(elems[8], backing_store),
					tc.lower(elems[9], backing_store),
					tc.lower(elems[10], backing_store),
					tc.lower(elems[11], backing_store),
					tc.lower(elems[12], backing_store),
					tc.lower(elems[13], backing_store),
					tc.lower(elems[14], backing_store),
					tc.lower(elems[15], backing_store),
				];
			{
				const ret = {};
				for (const i in elems) ret[i] = tc.lower(elems[i], backing_store);
				return ret;
			}
		},
	};
}
