import { ErrorMessage } from "./error_channels.js";
import * as WebSocket from "./polyfills/polyfill_ws.js";
import {
	BuildInfo,
	CommonCommandOptions,
	CommonWriteOptions,
	EventHandler,
	ExecutionStrategy,
	Generational,
	GlobalKeywordHandler,
	GlobalListener,
	KeywordHandler,
	KeywordListener,
	KeywordListenerType,
	KeywordPayload,
	KeywordWritePayload,
	KWLHandler,
	KWLListener,
	KWLName,
	Listener,
	ListenerID,
	MaybeMissing,
	Path,
	Request,
	SubtreePayload,
	SysName,
	TimeoutContext,
	WaitUntilOptions,
	Watcher,
	WebSocketParameters,
	WriteOptions,
} from "./pervasives.js";
import * as V2 from "./schema_v2.js";
import { ChildDescription } from "./schema_v2.js";
import { Duration } from "./time.js";
export declare class ThumbnailListener implements Listener {
	readonly id: ListenerID;
	private readonly destructor;
	constructor(id: ListenerID, destructor: (self: ThumbnailListener) => void);
	unregister(): void;
}
interface ProtocolFeatures {
	create_row_request_id: boolean;
	runtime_constants_json: boolean;
	readable_command_tracking: boolean;
	vscriptd: boolean;
	http_network_config: boolean;
}
export type Failure =
	| {
			type: "access-denied";
			kwl: KWLName<"full">;
			kw?: SysName;
			reason: string;
	  }
	| {
			type: "create-row";
			kwl: KWLName<"full">;
			opts: {
				index?: number;
				name?: string;
				allow_reuse_row?: boolean;
			};
	  }
	| {
			type: "delete-rows";
			kwls: KWLName<"full">[];
	  }
	| {
			type: "rename-row";
			kwl: KWLName<"full">;
			name: string;
	  }
	| {
			type: "write";
			kwl: KWLName<"full">;
			kw: SysName;
			payload: KeywordPayload;
			reason?: string;
	  }
	| {
			type: "read";
			kwl: KWLName<"full">;
			kw: SysName;
	  }
	| {
			type: "wait-until";
			kwl: KWLName<"full">;
			kw: SysName;
			timeout: Duration;
			criterion: (payload: KeywordPayload) => boolean;
	  };
interface Towel {
	value: string;
	state: TowelState;
}
declare const enum TowelState {
	Blocking = 0,
	Set = 1,
	Unset = 2,
}
export type FailureHandler = (failure: Failure) => void;
export declare function stringify_failure(
	failure: Failure,
	vsocket: VSocket,
): string;
export type VSocketParameters = WebSocketParameters & {
	timeout?: Duration;
	remove_unhandled_subscriptions?: boolean;
	ignored_modules?: string[];
	event_handler?: (ev: VSocketEvent) => void;
	permit_degraded_mode?: boolean;
	check_towel_on_write?: boolean;
	failure_handler?: FailureHandler;
};
export interface PendingMarker {
	expiryDateMS: number;
	resolve: () => void;
	reject: (error: Error) => void;
}
type CloseReason = "reboot" | "reset";
export type VSocketEvent =
	| {
			event_type: "expected-close";
			reason: CloseReason;
	  }
	| {
			event_type: "unexpected-close";
	  }
	| {
			event_type: "websocket-error";
	  }
	| {
			event_type: "error";
			error: any;
	  }
	| {
			event_type: "info";
			msg: string;
	  }
	| {
			event_type: "connection-reopened";
	  };
export declare class VSocket {
	static readonly INTERVAL_SECS = 1;
	private static schema_cache;
	private static s_timeout_scale;
	private handle_error;
	private readonly m_pending_subscriptions;
	private readonly m_kwl_cache;
	private state;
	max_messages_per_burst: number;
	get check_component_liveness(): boolean;
	protected static scaledTimeout(suggested: Duration | undefined): Duration;
	dump_stats(): void;
	static setTimeoutScale(factor: number): void;
	private readonly connection_pars;
	private outbound_snooper;
	private listener_registry;
	prune_listeners(
		keep_if: (pars: {
			kwl?: KWLName<"full">;
			kw?: SysName;
			listener_id: ListenerID;
		}) => boolean,
	): void;
	constructor(pars: VSocketParameters);
	private do_check_write;
	is_ready(): boolean;
	private get_state;
	get protocol_features(): ProtocolFeatures;
	set_snooper(outbound: null | ((requests: Request[]) => void)): void;
	set_failure_handler(failure_handler: null | FailureHandler): void;
	identify(): string;
	get current_towel(): Towel;
	get build_info(): BuildInfo;
	get ip(): string;
	get login(): {
		user: string;
		password: string;
	} | null;
	get protocol(): "ws" | "wss";
	get port(): number;
	get towel(): string;
	get runtime_constants(): RuntimeConstants;
	get schema(): V2.Schema<"annotated">;
	get module_registry(): ModuleRegistry;
	get root(): Root<VSocket>;
	place_towel(pars?: {
		override_preexisting_towel: boolean;
	}): Promise<void>;
	subscription_flush(): Promise<void>;
	watch_error_channels(
		handler: (msg: ErrorMessage) => void,
		opts?: {
			listener_id?: ListenerID;
		},
	): Promise<Watcher[]>;
	private recover_subscriptions;
	marker(pars?: {
		timeout?: Duration;
		flush_subscriptions?: boolean;
	}): Promise<void>;
	query_cache<T extends KeywordPayload = KeywordPayload>(
		path: Path<"full">,
	): MaybeMissing<Generational<T>>;
	query_cache_kwl(
		kwl: KWLName<"full">,
	): MaybeMissing<Generational<Map<SysName, Generational<KeywordPayload>>>>;
	private do_get_runtime_constant;
	get_runtime_constant(constant_string: string): number | boolean;
	send(req: Request[]): void;
	read_unchecked<T extends KeywordPayload = KeywordPayload>(
		path: Path<"full">,
		raw_timeout?: Duration,
	): Promise<T>;
	write_unchecked<T extends KeywordPayload = KeywordPayload>(
		path: Path<"full">,
		payload: T,
	): void;
	static open(pars: VSocketParameters): Promise<VSocket>;
	private do_open_connection;
	close(): Promise<void>;
	recovery(pars?: {
		timeout?: Duration;
	}): Promise<void>;
	register_kw_listener<T extends KeywordPayload = KeywordPayload>(
		pars: Path<"full"> & {
			listener_id?: ListenerID;
			cache?: boolean;
			listener_type: KeywordListenerType;
			execution_strategy: ExecutionStrategy;
			ensure_initial_read?: boolean;
		},
		handler: KeywordHandler<T>,
	): KeywordListener;
	register_kwl_listener(
		pars: {
			kwl: KWLName<"full">;
			listener_id?: ListenerID;
			cache?: boolean;
			listener_type: KeywordListenerType;
			execution_strategy: ExecutionStrategy;
			ensure_initial_read?: boolean;
		},
		handler: KWLHandler,
	): KWLListener;
	register_global_listener(
		handler: GlobalKeywordHandler,
		pars?: {
			listener_id?: ListenerID;
		},
	): GlobalListener;
	private subscribe_to;
	register_thumbnail_listener(
		handler: KeywordHandler<WebSocket.Binary>,
		pars?: {
			listener_id?: string;
		},
	): ThumbnailListener;
	private handle_incoming;
	read<T extends KeywordPayload = KeywordPayload>(
		full_path: Path<"full">,
		opts?: CommonCommandOptions & {
			use_cache_if_present?: boolean;
		},
	): Promise<T>;
	private wait_until_offline;
	reboot(pars?: {
		command?: "reboot" | "system0" | "system1";
		timeout?: Duration;
	}): Promise<void>;
	reset(pars?: {
		timeout?: Duration;
		partition?: "system0" | "system1";
	}): Promise<void>;
	/**
	 * attempt to create a new row within table <table_kwl>, returning the newly
	 * created row's index and name if successful and null otherwise. If neither
	 * <desired_index> nor <desired_name> are specified, the system will choose an
	 * unoccupied row index at its own discretion. Throws on allocation failure
	 */
	table_create_row(
		opts: CommonWriteOptions & {
			table_kwl: KWLName<"full">;
			index?: number;
			name?: string;
			allow_reuse_row?: boolean;
		},
	): Promise<[number, string]>;
	table_rename_row(
		opts: CommonWriteOptions & {
			row_kwl: KWLName<"full">;
			desired_name: string;
		},
	): Promise<void>;
	/**
	 * returns the currently allocated row indices of table <table_kwl>.
	 */
	table_indices(
		opts: CommonCommandOptions & {
			table_kwl: KWLName<"full">;
		},
	): Promise<number[]>;
	/**
	 * checks whether <table_kwl>[<index>] is currently allocated
	 */
	table_has_row(
		opts: CommonCommandOptions & {
			table_kwl: KWLName<"full">;
			index: number;
		},
	): Promise<boolean>;
	/**
	 * attempts to delete <table_kwl>[<index>]. Note that a delete request may be
	 * refused, as some allocatable objects need to be deactivated prior to removal
	 */
	table_delete_row(
		opts: CommonWriteOptions & {
			table_kwl: KWLName<"full">;
			index: number;
		},
	): Promise<void>;
	/**
	 * attempts to delete all rows of <table_kwl>. Note that a delete request may be
	 * refused, as some allocatable objects need to be deactivated prior to removal
	 */
	table_delete_all_rows(
		opts: CommonWriteOptions & {
			table_kwl: KWLName<"full">;
		},
	): Promise<void>;
	write<
		T extends KeywordPayload = KeywordPayload,
		P extends KeywordWritePayload = T,
	>(full_path: Path<"full">, payload: P, opts?: WriteOptions<T>): Promise<void>;
	wait_until<T extends KeywordPayload = KeywordPayload>(
		full_path: Path<"full">,
		criterion: (payload: T) => boolean,
		opts?: WaitUntilOptions,
	): Promise<T>;
	watch_unchecked<T extends KeywordPayload = KeywordPayload>(
		full_path: Path<"full">,
		handler: (payload: T) => void,
		opts?: CommonCommandOptions & {
			ensure_initial_read?: boolean;
			listener_id?: ListenerID;
		},
	): Watcher;
	watch<T extends KeywordPayload = KeywordPayload>(
		full_path: Path<"full">,
		handler: (payload: T) => void,
		opts?: CommonCommandOptions & {
			ensure_initial_read?: boolean;
			listener_id?: ListenerID;
		},
	): Promise<Watcher>;
	do_check_readonly(
		full_kwl: KWLName<"full">,
		opts?: {
			check_component_liveness?: boolean;
		},
	): void;
}
export declare class SubtreeArray<BackingStore extends VSocket | VSettings> {
	readonly backing_store: BackingStore;
	readonly kwl_basename: KWLName<"full">;
	readonly description: V2.SubtreeArrayContainer;
	constructor(
		backing_store: BackingStore,
		kwl_basename: KWLName<"full">,
		description: V2.SubtreeArrayContainer,
	);
	row(index: number): Subtree<BackingStore>;
	[Symbol.iterator](): Iterator<Subtree<BackingStore>>;
}
export declare class Subtree<BackingStore extends VSocket | VSettings> {
	readonly backing_store: BackingStore;
	readonly kwl: KWLName<"full">;
	readonly description:
		| V2.SubtreeDescription<"annotated">
		| V2.ComponentDescription<"annotated">;
	constructor(
		backing_store: BackingStore,
		kwl: KWLName<"full">,
		description:
			| V2.SubtreeDescription<"annotated">
			| V2.ComponentDescription<"annotated">,
	);
	get parent():
		| Subtree<BackingStore>
		| Root<BackingStore>
		| SubtreeArray<BackingStore>
		| SubtreeTable<BackingStore>
		| SubtreeNamedTable<BackingStore>;
	get children(): Array<ChildDescription<"annotated">>;
	toString(): string;
	to_full_kwl(kwl_relative: KWLName<"relative">): KWLName<"full">;
	to_full_path(path_relative: Path<"relative">): {
		kwl: KWLName<"full">;
		kw: SysName;
	};
	private st_desc;
	find(
		relative_kwl: KWLName<"relative">,
	):
		| Subtree<BackingStore>
		| SubtreeArray<BackingStore>
		| SubtreeTable<BackingStore>
		| SubtreeNamedTable<BackingStore>
		| undefined;
	query_cache<T extends KeywordPayload = KeywordPayload>(
		path: Path<"relative">,
	): MaybeMissing<Generational<T>>;
	query_cache_kwl(
		kwl: KWLName<"relative">,
	): MaybeMissing<Generational<Map<SysName, Generational<KeywordPayload>>>>;
	write_unchecked<T extends KeywordPayload = KeywordPayload>(
		path: Path<"relative">,
		payload: T,
	): void;
	read<T extends KeywordPayload = KeywordPayload>(
		path: Path<"relative">,
		opts?: CommonCommandOptions & {
			use_cache_if_present?: boolean;
		},
	): Promise<T>;
	read_unchecked<T extends KeywordPayload = KeywordPayload>(
		path: Path<"relative">,
		timeout?: Duration,
	): Promise<T>;
	write_tree_unchecked(kwl: KWLName<"relative">, payload: SubtreePayload): void;
	write<
		T extends KeywordPayload = KeywordPayload,
		P extends KeywordWritePayload = T,
	>(path: Path<"relative">, payload: P, opts?: WriteOptions<T>): Promise<void>;
	wait_until<T extends KeywordPayload = KeywordPayload>(
		path: Path<"relative">,
		criterion: (payload: T) => boolean,
		opts?: WaitUntilOptions,
	): Promise<T>;
	watch_unchecked<T extends KeywordPayload = KeywordPayload>(
		path: Path<"relative">,
		handler: (payload: T) => void,
		opts?: CommonCommandOptions & {
			ensure_initial_read?: boolean;
		},
	): Watcher;
	watch<T extends KeywordPayload = KeywordPayload>(
		path: Path<"relative">,
		handler: (payload: T) => void,
		opts?: CommonCommandOptions & {
			ensure_initial_read?: boolean;
		},
	): Promise<Watcher>;
}
export declare function deref<BackingStore extends VSocket | VSettings>(
	backing_store: BackingStore,
	path: Path<"full">,
	_opts?: CommonCommandOptions,
): Promise<null | Subtree<BackingStore>>;
export declare class Root<BackingStore extends VSocket | VSettings> {
	readonly backing_store: BackingStore;
	constructor(backing_store: BackingStore);
	get components(): Array<V2.ComponentDescription<"annotated">>;
	find(
		kwl: KWLName<"full">,
	):
		| Subtree<BackingStore>
		| SubtreeArray<BackingStore>
		| SubtreeTable<BackingStore>
		| SubtreeNamedTable<BackingStore>
		| undefined;
}
export declare class SubtreeTable<BackingStore extends VSocket | VSettings> {
	readonly backing_store: BackingStore;
	readonly kwl: KWLName<"full">;
	readonly description: V2.TableContainer;
	constructor(
		backing_store: BackingStore,
		kwl: KWLName<"full">,
		description: V2.TableContainer,
	);
	get parent(): Subtree<BackingStore> | Root<BackingStore>;
	allocated_indices(opts?: CommonCommandOptions): Promise<number[]>;
	is_allocated(index: number, opts?: CommonCommandOptions): Promise<boolean>;
	rows(opts?: CommonCommandOptions): Promise<SubtreeTableRow<BackingStore>[]>;
	row(index: number): SubtreeTableRow<BackingStore>;
	row_unchecked(index: number): SubtreeTableRow<BackingStore>;
	[Symbol.asyncIterator](): AsyncGenerator<
		never,
		Generator<SubtreeTableRow<BackingStore>, void, unknown>,
		unknown
	>;
}
export declare class SubtreeNamedTable<
	BackingStore extends VSocket | VSettings,
> extends SubtreeTable<BackingStore> {
	constructor(
		backing_store: BackingStore,
		kwl: KWLName<"full">,
		description: V2.TableContainer,
	);
	create_row(
		opts?: CommonWriteOptions & {
			index?: number;
			name?: string;
			allow_reuse_row?: boolean;
		},
	): Promise<SubtreeNamedTableRow<BackingStore>>;
	rows(
		opts?: CommonCommandOptions,
	): Promise<SubtreeNamedTableRow<BackingStore>[]>;
	row(
		index: number,
		_?: CommonCommandOptions,
	): SubtreeNamedTableRow<BackingStore>;
	row_unchecked(index: number): SubtreeNamedTableRow<BackingStore>;
	delete_all(opts?: {
		timeout?: Duration;
	}): Promise<void>;
}
export declare class SubtreeTableRow<
	BackingStore extends VSocket | VSettings,
> extends Subtree<BackingStore> {
	constructor(
		backing_store: BackingStore,
		kwl: KWLName<"full">,
		description: V2.SubtreeDescription<"annotated">,
	);
	get index(): number;
}
export declare class SubtreeNamedTableRow<
	BackingStore extends VSocket | VSettings,
> extends SubtreeTableRow<BackingStore> {
	constructor(
		backing_store: BackingStore,
		kwl: KWLName<"full">,
		description: V2.SubtreeDescription<"annotated">,
	);
	rename(desired_name: string, opts?: CommonWriteOptions): Promise<void>;
	row_name(opts?: CommonCommandOptions): Promise<string>;
	delete(opts?: CommonWriteOptions): Promise<void>;
}
export declare enum ComponentState {
	Unknown = 0,
	Disabled = 1,
	Uninitialized = 2,
	Running = 3,
	Crashed = 4,
}
export type ChangeHandler = (
	component_sys_name: SysName,
	state: ComponentState,
) => void;
export declare class ModuleRegistry {
	static DISABLED: number;
	private data;
	private sys_names;
	private change_handlers;
	private constructor();
	on_change(
		f: (component_sys_name: SysName, state: ComponentState) => void,
	): EventHandler;
	static initialize(
		components: V2.ComponentDescription<"raw">[],
		socket: VSocket,
		degraded_mode: boolean,
		context: TimeoutContext,
	): Promise<ModuleRegistry>;
	is_online(component_sys_name: string): boolean;
	is_disabled(component_sys_name: string): boolean;
	get_status(component_sys_name: string): {
		pid: number;
		crashed: boolean;
	};
}
export interface RawRuntimeConstants {
	[component_sys_name: string]: {
		[constant_name: string]: number | boolean;
	};
}
export declare class RuntimeConstants {
	private readonly data;
	private constructor();
	get_constant(
		component_sys_name: string,
		constant_name: string,
	): number | boolean;
	equal(other: RuntimeConstants): boolean;
	static initialize(
		schema: V2.Schema<"raw">,
		socket: VSocket,
		timeout: Duration,
		context: TimeoutContext,
	): Promise<[RuntimeConstants, Set<SysName>]>;
}
export interface StoredKeyword<T extends KeywordPayload = KeywordPayload> {
	isDefault: boolean;
	data: T;
}
export interface StoredSubtree {
	kw: Record<string, StoredKeyword>;
	kwl: Record<string, StoredSubtree | StoredNamedTable>;
}
export interface StoredNamedTableRow extends StoredSubtree {
	id: string;
	idx: number;
}
export interface StoredNamedTable {
	"named-rows": StoredNamedTableRow[];
}
export interface ISettings {
	format: string;
	header: {
		fpga: string;
		version: [version: string, build_date: string];
		flags: ["everything"] | [];
	};
	components: Record<string, StoredSubtree>;
}
export declare class VSettings {
	readonly schema: V2.Schema<"annotated">;
	readonly build_info: BuildInfo;
	private readonly m_identifier?;
	private m_data;
	private listener_registry;
	private open_handlers;
	constructor(
		schema: V2.Schema<"annotated">,
		build_info: BuildInfo,
		json: any,
		m_identifier?: string | undefined,
	);
	identify(): string;
	get root(): Root<VSettings>;
	is_ready(): boolean;
	marker(): Promise<void>;
	find_subtree(
		kwl: KWLName<"full">,
	): undefined | StoredSubtree | StoredNamedTable;
	find_keyword(path: Path<"full">): undefined | StoredKeyword;
	query_cache<T extends KeywordPayload = KeywordPayload>(
		path: Path<"full">,
	): MaybeMissing<Generational<T>>;
	query_cache_kwl(
		kwl: KWLName<"full">,
	): MaybeMissing<Generational<Map<SysName, Generational<KeywordPayload>>>>;
	get_runtime_constant(constant_string: string): number | boolean;
	register_kw_listener<T extends KeywordPayload = KeywordPayload>(
		pars: Path<"full"> & {
			listener_id?: ListenerID;
			cache?: boolean;
			listener_type: KeywordListenerType;
			execution_strategy: ExecutionStrategy;
			ensure_initial_read?: boolean;
		},
		handler: KeywordHandler<T>,
	): KeywordListener;
	register_kwl_listener(
		pars: {
			kwl: KWLName<"full">;
			listener_id?: ListenerID;
			cache?: boolean;
			listener_type: KeywordListenerType;
			execution_strategy: ExecutionStrategy;
			ensure_initial_read?: boolean;
		},
		handler: KWLHandler,
	): KWLListener;
	register_global_listener(
		handler: GlobalKeywordHandler,
		pars?: {
			listener_id?: ListenerID;
		},
	): GlobalListener;
	on_open(f: () => void, suggested_id?: string): EventHandler;
	write_unchecked<T extends KeywordPayload = KeywordPayload>(
		path: Path<"full">,
		payload: T,
	): void;
	write<
		T extends KeywordPayload = KeywordPayload,
		P extends KeywordWritePayload = T,
	>(path: Path<"full">, payload: P, _?: WriteOptions<T>): Promise<void>;
	send(requests: Request[]): void;
	read_unchecked<T extends KeywordPayload = KeywordPayload>(
		path: Path<"full">,
	): Promise<T>;
	read<T extends KeywordPayload = KeywordPayload>(
		full_path: Path<"full">,
		opts?: CommonCommandOptions & {
			use_cache_if_present?: boolean;
		},
	): Promise<T>;
	/**
	 * attempt to create a new row within table <table_kwl>, returning the newly
	 * created row's index and name if successful and null otherwise. If neither
	 * <desired_index> nor <desired_name> are specified, the system will choose an
	 * unoccupied row index at its own discretion. Throws on allocation failure
	 */
	table_create_row(
		opts: CommonWriteOptions & {
			table_kwl: KWLName<"full">;
			index?: number;
			name?: string;
			allow_reuse_row?: boolean;
		},
	): Promise<[number, string]>;
	table_rename_row(
		opts: CommonWriteOptions & {
			row_kwl: KWLName<"full">;
			desired_name: string;
		},
	): Promise<void>;
	/**
	 * returns the currently allocated row indices of table <table_kwl>.
	 */
	table_indices(
		opts: CommonCommandOptions & {
			table_kwl: KWLName<"full">;
		},
	): Promise<number[]>;
	/**
	 * checks whether <table_kwl>[<index>] is currently allocated
	 */
	table_has_row(
		opts: CommonCommandOptions & {
			table_kwl: KWLName<"full">;
			index: number;
		},
	): Promise<boolean>;
	/**
	 * attempts to delete <table_kwl>[<index>]. Note that a delete request may be
	 * refused, as some allocatable objects need to be deactivated prior to removal
	 */
	table_delete_row(
		opts: CommonWriteOptions & {
			table_kwl: KWLName<"full">;
			index: number;
		},
	): Promise<void>;
	table_delete_all_rows(
		opts: CommonWriteOptions & {
			table_kwl: KWLName<"full">;
		},
	): Promise<void>;
	wait_until<T extends KeywordPayload = KeywordPayload>(
		full_path: Path<"full">,
		criterion: (payload: T) => boolean,
		opts?: WaitUntilOptions,
	): Promise<T>;
	watch_unchecked<T extends KeywordPayload = KeywordPayload>(
		full_path: Path<"full">,
		handler: (payload: T) => void,
		opts?: CommonCommandOptions & {
			ensure_initial_read?: boolean;
		},
	): Watcher;
	watch<T extends KeywordPayload = KeywordPayload>(
		full_path: Path<"full">,
		handler: (payload: T) => void,
		opts?: CommonCommandOptions & {
			ensure_initial_read?: boolean;
		},
	): Promise<Watcher>;
}
export {};
