import { enforce } from "./utilities.js";
const message_re = new RegExp(
		/^<([0-9]+)>[^\s]+\s+[0-9]+\s+[0-9]+:[0-9]+:[0-9]+\s+([^ ]+?):(.*)/,
	),
	ALL_LEVELS = [
		"Emergency",
		"Alert",
		"Critical",
		"Error",
		"Warning",
		"Notice",
		"Info",
		"Debug",
	];
export function int_of_level(level) {
	return ALL_LEVELS.findIndex((l) => l === level);
}
export function level_of_int(i) {
	return ALL_LEVELS[i];
}
export function read_error_message(message_md) {
	const m = message_md.match(message_re);
	if (null === m) return null;
	const level_raw = parseInt(m[1]) - 8,
		originator = m[2],
		content_md = m[3].trim();
	return level_raw >= 0 && level_raw < ALL_LEVELS.length
		? {
				level: level_of_int(level_raw),
				originator: originator,
				content_md: content_md,
			}
		: { level: "Alert", originator: originator, content_md: content_md };
}
