import { enforce } from "./utilities.js";
export class UnorderedArrayImpl {
	data = [];
	register(interval, handler) {
		this.data.push([interval[0], interval[1], handler]);
	}
	find(key) {
		const result = [];
		for (const el of this.data)
			el[0] <= key && el[1] >= key && result.push(el[2]);
		return result;
	}
}
export class OrderedArrayImpl {
	data = [];
	register(interval, handler) {
		this.data.push([interval[0], interval[1], handler]),
			this.data.sort((a, b) => a[0] - b[0]);
	}
	find(key) {
		const result = [];
		if (0 !== this.data.length && this.data[0][0] <= key)
			for (let i = 0; i < this.data.length; ++i)
				if (this.data[i][0] <= key && this.data[i][1] >= key)
					result.push(this.data[i][2]);
				else if (this.data[i][0] > key) break;
		return result;
	}
}
export class OrderedTypedArrayImpl {
	sentinel;
	intervals = new Uint32Array(24);
	handlers = [];
	dummy_handler = (_, __) => {};
	compaction_timer = null;
	max_interval_size = 0;
	constructor(sentinel) {
		(this.sentinel = sentinel), this.intervals.fill(this.sentinel);
	}
	get size() {
		return this.handlers.length;
	}
	grow() {
		let new_intervals = new Uint32Array(2 * this.intervals.length);
		new_intervals.fill(this.sentinel),
			new_intervals.set(this.intervals),
			(this.intervals = new_intervals);
	}
	find_i(key) {
		if (this.intervals[3 * (this.size - 1)] <= key) return this.size;
		if (this.intervals[0] > key) return 0;
		let i_lower = 0,
			i_upper = this.size;
		for (; i_lower + 1 < i_upper; ) {
			const i_mid = (i_lower + i_upper) >> 1;
			this.intervals[3 * i_mid] <= key ? (i_lower = i_mid) : (i_upper = i_mid);
		}
		return i_upper;
	}
	delete(key, h) {
		for (let i = this.find_i(key) - 1; i >= 0; --i) {
			if (this.handlers[this.intervals[3 * i + 2]] === h) {
				(this.handlers[this.intervals[3 * i + 2]] = this.dummy_handler),
					this.intervals.copyWithin(3 * i, 3 * i + 3, 3 * this.size + 3),
					this.compaction_timer && clearTimeout(this.compaction_timer),
					(this.compaction_timer = setTimeout(() => {
						this.compact(), (this.compaction_timer = null);
					}, 200));
				break;
			}
			if (this.intervals[3 * i] < key) break;
		}
	}
	compact() {
		let max_interval_size = 0;
		const deltas = [{ index: 0, deficit: 0 }],
			new_handlers = [];
		let cur_deficit = 0;
		for (let i = 0; i < this.handlers.length; ++i)
			this.handlers[i] === this.dummy_handler
				? ((cur_deficit += 1),
					deltas.push({ index: i + 1, deficit: cur_deficit }))
				: new_handlers.push(this.handlers[i]);
		for (let i = 0; this.intervals[i] !== this.sentinel; i += 3) {
			max_interval_size = Math.max(
				max_interval_size,
				this.intervals[i + 1] - this.intervals[i],
			);
			const handler_index = this.intervals[i + 2];
			let cur_deficit = 0;
			for (const { index: index, deficit: deficit } of deltas) {
				if (index > handler_index) break;
				cur_deficit = deficit;
			}
			this.intervals[i + 2] -= cur_deficit;
		}
		(this.max_interval_size = max_interval_size),
			(this.handlers = new_handlers);
	}
	print() {
		let s = "[";
		for (let i = 0; i < this.size; ++i)
			i > 0 && (s += ", "),
				(s += `(${this.intervals[3 * i]}, ${this.intervals[3 * i + 1]}, ${this.intervals[3 * i + 2]})`);
	}
	register(interval, handler) {
		3 * (this.size + 2) >= this.intervals.length && this.grow();
		const i_insert = this.find_i(interval[0]);
		return (
			this.intervals.copyWithin(
				3 * (i_insert + 1),
				3 * i_insert,
				3 * this.size + 3,
			),
			(this.intervals[3 * i_insert] = interval[0]),
			(this.intervals[3 * i_insert + 1] = interval[1]),
			(this.intervals[3 * i_insert + 2] = this.size),
			this.handlers.push(handler),
			(this.max_interval_size = Math.max(
				this.max_interval_size,
				interval[1] - interval[0],
			)),
			{
				unregister: () => {
					this.delete(interval[0], handler);
				},
			}
		);
	}
	find(id) {
		let result = [];
		for (
			let i =
				id > this.max_interval_size + 1
					? 3 * this.find_i(id - this.max_interval_size - 1)
					: 0;
			this.intervals[i] <= id;
			i += 3
		)
			this.intervals[i + 1] >= id &&
				result.push(this.handlers[this.intervals[i + 2]]);
		return result;
	}
	invoke(id, payload) {
		for (
			let i =
				id > this.max_interval_size + 1
					? 3 * this.find_i(id - this.max_interval_size - 1)
					: 0;
			this.intervals[i] <= id;
			i += 3
		)
			this.intervals[i + 1] >= id &&
				this.handlers[this.intervals[i + 2]](payload, id);
	}
}
export class OrderedTypedSOAImpl {
	sentinel;
	mins = new Uint32Array(8);
	maxs = new Uint32Array(8);
	handler_ids = new Uint32Array(8);
	handlers = [];
	dummy_handler = (_, __) => {};
	compaction_timer = null;
	max_interval_size = 0;
	constructor(sentinel) {
		(this.sentinel = sentinel), this.mins.fill(this.sentinel);
	}
	get size() {
		return this.handlers.length;
	}
	grow() {
		let new_mins = new Uint32Array(2 * this.mins.length);
		new_mins.fill(this.sentinel),
			new_mins.set(this.mins),
			(this.mins = new_mins);
		let new_maxs = new Uint32Array(2 * this.maxs.length);
		new_maxs.fill(this.sentinel),
			new_maxs.set(this.maxs),
			(this.maxs = new_maxs);
		let new_handler_ids = new Uint32Array(2 * this.handler_ids.length);
		new_handler_ids.set(this.handler_ids), (this.handler_ids = new_handler_ids);
	}
	find_i(key) {
		if (this.mins[this.size - 1] <= key) return this.size;
		if (this.mins[0] > key) return 0;
		let i_lower = 0,
			i_upper = this.size;
		for (; i_lower + 1 < i_upper; ) {
			const i_mid = (i_lower + i_upper) >> 1;
			this.mins[i_mid] <= key ? (i_lower = i_mid) : (i_upper = i_mid);
		}
		return i_upper;
	}
	delete(key, h) {
		for (let i = this.find_i(key) - 1; i >= 0; --i) {
			if (this.handlers[this.handler_ids[i]] === h) {
				(this.handlers[this.handler_ids[i]] = this.dummy_handler),
					this.mins.copyWithin(i, i + 1, this.size + 1),
					this.maxs.copyWithin(i, i + 1, this.size + 1),
					this.handler_ids.copyWithin(i, i + 1, this.size + 1),
					this.compaction_timer && clearTimeout(this.compaction_timer),
					(this.compaction_timer = setTimeout(() => {
						this.compact(), (this.compaction_timer = null);
					}, 200));
				break;
			}
			if (this.mins[i] < key) break;
		}
	}
	compact() {
		let max_interval_size = 0;
		const deltas = [{ index: 0, deficit: 0 }],
			new_handlers = [];
		let cur_deficit = 0;
		for (let i = 0; i < this.handlers.length; ++i)
			this.handlers[i] === this.dummy_handler
				? ((cur_deficit += 1),
					deltas.push({ index: i + 1, deficit: cur_deficit }))
				: new_handlers.push(this.handlers[i]);
		for (let i = 0; this.mins[i] !== this.sentinel; i++) {
			max_interval_size = Math.max(
				max_interval_size,
				this.maxs[i] - this.mins[i],
			);
			const handler_index = this.handler_ids[i];
			let cur_deficit = 0;
			for (const { index: index, deficit: deficit } of deltas) {
				if (index > handler_index) break;
				cur_deficit = deficit;
			}
			this.handler_ids[i] -= cur_deficit;
		}
		(this.max_interval_size = max_interval_size),
			(this.handlers = new_handlers);
	}
	print() {}
	register(interval, handler) {
		this.size + 2 >= this.mins.length && this.grow();
		const i_insert = this.find_i(interval[0]);
		return (
			this.mins.copyWithin(i_insert + 1, i_insert, this.size + 1),
			this.maxs.copyWithin(i_insert + 1, i_insert, this.size + 1),
			this.handler_ids.copyWithin(i_insert + 1, i_insert, this.size + 1),
			(this.mins[i_insert] = interval[0]),
			(this.maxs[i_insert] = interval[1]),
			(this.handler_ids[i_insert] = this.size),
			this.handlers.push(handler),
			(this.max_interval_size = Math.max(
				this.max_interval_size,
				interval[1] - interval[0],
			)),
			{
				unregister: () => {
					this.delete(interval[0], handler);
				},
			}
		);
	}
	find(id) {
		let result = [];
		for (
			let i =
				id > this.max_interval_size + 1
					? this.find_i(id - this.max_interval_size - 1)
					: 0;
			this.mins[i] <= id;
			i++
		)
			this.maxs[i] >= id && result.push(this.handlers[this.handler_ids[i]]);
		return result;
	}
	invoke(id, payload) {
		for (
			let i =
				id > this.max_interval_size + 1
					? this.find_i(id - this.max_interval_size - 1)
					: 0;
			this.mins[i] <= id;
			i++
		)
			this.maxs[i] >= id && this.handlers[this.handler_ids[i]](payload, id);
	}
}
