import { StringIDPool } from "./id_pool.js";
import { enforce, enforce_nonnull } from "./utilities.js";
function add_marker(m, n, i) {
	n.markers[i].push(m),
		-1 === n.eq_markers.findIndex((m2) => m2 === m) && n.eq_markers.push(m);
	const next = n.forward[i];
	-1 === next.eq_markers.findIndex((m2) => m2 === m) && next.eq_markers.push(m);
}
function maybe_remove_marker(m, n, i) {
	const i_marker = n.markers[i].findIndex((m2) => m2 === m);
	if (-1 !== i_marker) {
		n.markers[i].splice(i_marker, 1);
		const l = n.eq_markers.findIndex((m2) => m2 === m);
		-1 !== l && n.eq_markers.splice(l, 1);
		const next = n.forward[i],
			j = next.eq_markers.findIndex((m2) => m2 === m);
		return -1 !== j && next.eq_markers.splice(j, 1), !0;
	}
	return !1;
}
export class ListenerSkipList {
	static MAX_LEVELS = 24;
	head;
	level = 1;
	intervals = new Map();
	constructor(max_id) {
		const end = {
			key: max_id + 1,
			forward: [],
			markers: [],
			eq_markers: [],
			owners: [],
		};
		this.head = {
			key: 0,
			forward: Array.from({ length: ListenerSkipList.MAX_LEVELS }, (_) => end),
			markers: Array.from({ length: ListenerSkipList.MAX_LEVELS }, (_) => []),
			eq_markers: [],
			owners: [],
		};
	}
	static random_level() {
		let lvl = 1;
		for (; Math.random() < 0.5 && lvl < ListenerSkipList.MAX_LEVELS; ) lvl++;
		return lvl;
	}
	insert_endpoint(search_key) {
		const update = Array.from({ length: ListenerSkipList.MAX_LEVELS });
		let x = this.head;
		for (let i = this.level - 1; i >= 0; --i) {
			for (; x.forward[i].key < search_key; ) x = x.forward[i];
			update[i] = x;
		}
		if ((x.forward[0], (x = x.forward[0]), x.key === search_key))
			return { N: x, updated: [] };
		{
			const lvl = ListenerSkipList.random_level();
			if (lvl > this.level) {
				for (let i = this.level; i < lvl; ++i) update[i] = this.head;
				this.level = lvl;
			}
			x = {
				key: search_key,
				forward: Array.from({ length: lvl }),
				markers: Array.from({ length: lvl }, (_) => []),
				eq_markers: [],
				owners: [],
			};
			for (let i = 0; i < lvl; ++i)
				update[i],
					(x.forward[i] = update[i].forward[i]),
					(update[i].forward[i] = x);
			return { N: x, updated: update.slice(0, lvl) };
		}
	}
	adjust_markers_on_insert(N, updated) {
		let promoted = new Set(),
			new_promoted = new Set();
		const remove_marker_from_path = (m, start, end, i) => {
				let x = start;
				for (; x.key < end.key; )
					for (let j = Math.min(i, x.forward.length - 1); j >= 0; --j)
						if (maybe_remove_marker(m, x, j) || 0 === j) {
							x = x.forward[j];
							break;
						}
			},
			lvl = N.forward.length;
		for (let i = 0; i <= lvl - 2; ++i) {
			updated[i], updated[i].markers[i];
			for (const m of updated[i].markers[i]) {
				const intvl = this.intervals.get(m);
				intvl.min <= N.key && intvl.max >= N.forward[i + 1].key
					? (remove_marker_from_path(m, N.forward[i], N.forward[i + 1], i),
						new_promoted.add(m))
					: add_marker(m, N, i);
			}
			for (const m of promoted.values()) {
				const intvl = this.intervals.get(m);
				intvl.min <= N.key && intvl.max >= N.forward[i + 1].key
					? remove_marker_from_path(m, N.forward[i], N.forward[i + 1], i)
					: (add_marker(m, N, i), promoted.delete(m));
			}
			(promoted = new Set([...promoted, ...new_promoted])),
				(new_promoted = new Set());
		}
		const LN = lvl - 1;
		for (const m of updated[LN].markers[LN]) promoted.add(m);
		N.markers[LN] = [];
		for (const m of promoted.values()) add_marker(m, N, LN);
		(promoted = new Set()), (new_promoted = new Set());
		for (let i = 0; i <= lvl - 2; ++i) {
			for (const m of updated[i].markers[i]) {
				const intvl = this.intervals.get(m);
				intvl.min <= updated[i + 1].key &&
					intvl.max >= N.key &&
					(remove_marker_from_path(m, updated[i + 1], N, i),
					new_promoted.add(m));
			}
			for (const m of promoted.values()) {
				const intvl = this.intervals.get(m);
				intvl.min <= updated[i].key &&
				intvl.max >= N.key &&
				!(intvl.min <= updated[i + 1].key)
					? (add_marker(m, updated[i], i), promoted.delete(m))
					: remove_marker_from_path(m, updated[i + 1], N, i);
			}
			(promoted = new Set([...promoted, ...new_promoted])),
				(new_promoted = new Set());
		}
		const top = lvl - 1;
		for (const m of updated[top].markers[top]) promoted.add(m);
		updated[top].markers[top] = [];
		for (const m of promoted.values()) add_marker(m, updated[top], top);
	}
	place_markers(m) {
		const intvl = this.intervals.get(m);
		let x = this.find_node(intvl.min);
		x.eq_markers.push(m);
		let i = 0;
		for (; x.forward[i].key <= intvl.max; ) {
			for (; i !== x.forward.length - 1 && x.forward[i + 1].key <= intvl.max; )
				i += 1;
			add_marker(m, x, i), (x = x.forward[i]);
		}
		for (; x.key !== intvl.max; ) {
			for (; 0 !== i && !(intvl.max >= x.forward[i].key); ) i -= 1;
			add_marker(m, x, i), (x = x.forward[i]);
		}
	}
	find_node(key) {
		let x = this.head;
		for (let i = ListenerSkipList.MAX_LEVELS - 1; i >= 0; --i)
			for (; x.forward[i] && x.forward[i].key < key; ) x = x.forward[i];
		return (x = x.forward[0]), x.key === key ? x : null;
	}
	print() {
		let all_nodes = [];
		for (let x = this.head; x.forward.length > 0; x = x.forward[0])
			all_nodes.push(x);
		all_nodes.forEach((n) => {});
	}
	selfcheck() {
		let all_nodes = [];
		for (let x = this.head; x.forward.length > 0; x = x.forward[0])
			all_nodes.push(x);
		for (const node of all_nodes) {
			const all_markers = new Set();
			for (let i = 1; i < node.markers.length; ++i)
				for (const m of node.markers[i]) {
					all_markers.add(m);
					for (const other_node of all_nodes)
						if (!(other_node.key <= node.key)) {
							if (other_node.key >= node.forward[i].key) break;
							for (let j = 0; j < i && j < other_node.markers.length; ++j)
								-1 !== other_node.markers[j].findIndex((m2) => m2 === m) &&
									process.exit(7);
						}
				}
		}
	}
	find(key) {
		let x = this.head,
			S = new Set();
		for (let i = ListenerSkipList.MAX_LEVELS - 1; i > 0; --i) {
			for (; x.forward[i] && x.forward[i].key < key; ) x = x.forward[i];
			for (const m of x.markers[i]) S.add(m);
		}
		for (; x.forward[0].key < key; ) x = x.forward[0];
		if (x.forward[0].key !== key) for (const m of x.markers[0]) S.add(m);
		else for (const m of x.forward[0].eq_markers) S.add(m);
		const result = [];
		for (const el of S) result.push(this.intervals.get(el).handler);
		return result;
	}
	register(interval, handler) {
		const m = StringIDPool.generate_id();
		this.intervals.set(m, {
			min: interval[0],
			max: interval[1],
			handler: handler,
		});
		const ins_min = this.insert_endpoint(interval[0]);
		ins_min.updated.length > 0 &&
			this.adjust_markers_on_insert(ins_min.N, ins_min.updated);
		const ins_max = this.insert_endpoint(interval[1]);
		return (
			ins_max.updated.length > 0 &&
				this.adjust_markers_on_insert(ins_max.N, ins_max.updated),
			this.place_markers(m),
			{
				unregister: () => {
					this.unregister(m);
				},
			}
		);
	}
	unregister(m) {}
}
