import { enforce } from "./utilities.js";
export class StringIDPool {
	static s_cur_id = BigInt(0);
	static generate_id() {
		return (
			(StringIDPool.s_cur_id = StringIDPool.s_cur_id + BigInt(1)),
			StringIDPool.s_cur_id.toString(36)
		);
	}
	static generate_or_use_id(dict, suggested_id) {
		return suggested_id ?? StringIDPool.generate_id();
	}
}
export class NumericIDPool {
	static s_cur_id = 0;
	static MODULUS = Math.pow(2, 50);
	static generate_id() {
		return (
			(NumericIDPool.s_cur_id =
				(NumericIDPool.s_cur_id + 1) % NumericIDPool.MODULUS),
			NumericIDPool.s_cur_id
		);
	}
}
