import { SysName, KWLName } from "./pervasives.js";
import { AlertDescription } from "./schema_v2.js";
import { VSocket } from "./data_views.js";
export interface Unpacked {
	num_warnings: number;
	num_errors: number;
	num_total: number;
	issues: AlertDescription[];
	raw: number;
}
export declare function unpack(
	payload: number,
	issue_descriptions: AlertDescription[],
): Unpacked;
export declare function diff(
	prev: null | Unpacked,
	cur: Unpacked,
	issue_descriptions: AlertDescription[],
): {
	raised: AlertDescription[];
	lowered: AlertDescription[];
};
export declare class Tracker {
	readonly vsocket: VSocket;
	private readonly m_handler;
	private readonly m_watchers;
	private readonly m_cur_issues;
	constructor(
		vsocket: VSocket,
		m_handler: (
			kwl: KWLName<"full">,
			kw: SysName,
			update: {
				current: Unpacked;
				raised: AlertDescription[];
				lowered: AlertDescription[];
			},
		) => void,
	);
	get(kwl: KWLName<"full">, kw: SysName): Unpacked | undefined;
	get_all(): Array<
		[
			path: {
				kwl: KWLName<"full">;
				kw: SysName;
			},
			unpacked: Unpacked,
		]
	>;
	close(): void;
}
