import { enforce, enforce_nonnull } from "./utilities.js";
import { keyword_iter_sync } from "./schema_reflection.js";
export function unpack(payload, issue_descriptions) {
	const issues = [];
	let num_errors = 0,
		num_warnings = 0,
		num_total = 0;
	for (let i = 0, rem = payload; 0 !== rem; i++, rem >>= 1)
		if (1 & rem) {
			num_total++;
			const issue = issue_descriptions[i];
			switch ((issues.push(issue), issue.severity)) {
				case "Alert":
				case "Critical":
				case "Emergency":
				case "Error":
					num_errors++;
					break;
				case "Warning":
					num_warnings++;
			}
		}
	return {
		num_errors: num_errors,
		num_warnings: num_warnings,
		num_total: num_total,
		issues: issues,
		raw: payload,
	};
}
export function diff(prev, cur, issue_descriptions) {
	if (null === prev) return { lowered: [], raised: cur.issues };
	const intersection_raw = cur.raw & prev.raw,
		raised_raw = cur.raw ^ intersection_raw,
		lowered_raw = prev.raw ^ intersection_raw;
	return {
		raised: unpack(raised_raw, issue_descriptions).issues,
		lowered: unpack(lowered_raw, issue_descriptions).issues,
	};
}
export class Tracker {
	vsocket;
	m_handler;
	m_watchers = [];
	m_cur_issues = new Map();
	constructor(vsocket, m_handler) {
		(this.vsocket = vsocket),
			(this.m_handler = m_handler),
			keyword_iter_sync({
				backing_store: vsocket,
				handler: (_, desc, kwl) => {
					if (
						0 === desc.contents.container_type &&
						"alerts" === desc.contents.data_type
					) {
						const alerts = desc.contents.alerts,
							kw = desc.contents.sys_name;
						this.m_watchers.push(
							vsocket.watch_unchecked({ kwl: kwl, kw: kw }, (payload) => {
								const prev = this.get(kwl, kw) ?? null,
									current = unpack(payload, alerts),
									{ raised: raised, lowered: lowered } = diff(
										prev,
										current,
										alerts,
									);
								this.m_handler(kwl, kw, {
									current: current,
									raised: raised,
									lowered: lowered,
								}),
									this.m_cur_issues.has(kwl) ||
										this.m_cur_issues.set(kwl, new Map()),
									this.m_cur_issues.get(kwl).set(kw, current);
							}),
						);
					}
					return "recurse";
				},
			});
	}
	get(kwl, kw) {
		return this.m_cur_issues.get(kwl)?.get(kw);
	}
	get_all() {
		const result = [];
		for (const [kwl, x] of this.m_cur_issues)
			for (const [kw, unpacked] of x)
				0 !== unpacked.num_total &&
					result.push([{ kwl: kwl, kw: kw }, unpacked]);
		return result;
	}
	close() {
		this.m_watchers.forEach((w) => w.unwatch()),
			this.m_watchers.splice(0, this.m_watchers.length);
	}
}
