import { MissingData } from "./pervasives.js";
import {
	enforce_nonnull,
	path_index,
	path_strip_trailing_index,
} from "./utilities.js";
export class KWLCache {
	m_data = new Map();
	dump_stats() {
		let total = 0;
		for (const [_, entry] of this.m_data) total += entry[2].size;
	}
	register(data) {
		let entry = this.get_or_insert(data.kwl);
		for (const sys_name in data.kw)
			entry[2].set(sys_name, [
				((entry[2].get(sys_name)?.[0] ?? -1) + 1) & 268435455,
				data.kw[sys_name],
			]);
		for (; void 0 !== entry; ) (entry[1] = entry[1] + 1), (entry = entry?.[0]);
	}
	clear() {
		this.m_data.clear();
	}
	query_kw(path) {
		const maybe_payload = this.m_data.get(path.kwl)?.[2].get(path.kw);
		return void 0 === maybe_payload
			? MissingData
			: [maybe_payload[0], maybe_payload[1]];
	}
	query_kwl(kwl) {
		const maybe_entry = this.m_data.get(kwl);
		return void 0 === maybe_entry
			? MissingData
			: [maybe_entry[1], maybe_entry[2]];
	}
	get_or_insert(kwl) {
		const cur_entry = this.m_data.get(kwl);
		return void 0 !== cur_entry ? cur_entry : this.insert(kwl);
	}
	insert(kwl) {
		let cur_entry;
		const parts = kwl.split(".").flatMap((segment, i) => {
			const index = path_index(segment);
			return void 0 === index
				? [(0 === i ? "" : ".") + segment]
				: [
						(0 === i ? "" : ".") + path_strip_trailing_index(segment),
						`[${index}]`,
					];
		});
		let path = "";
		for (const part of parts) {
			path += part;
			let next_entry = this.m_data.get(path);
			void 0 === next_entry &&
				(this.m_data.set(path, [cur_entry, -1, new Map()]),
				(next_entry = this.m_data.get(path))),
				(cur_entry = next_entry);
		}
		return cur_entry;
	}
}
