import {
	ExecutionStrategy,
	GlobalKeywordHandler,
	GlobalListener,
	IListenerRegistry,
	KeywordHandler,
	KeywordListener,
	KeywordListenerType,
	KeywordPayload,
	KWLHandler,
	KWLListener,
	KWLName,
	ListenerID,
	SysName,
} from "./pervasives.js";
export declare class ListenerRegistry implements IListenerRegistry {
	private readonly m_error_handler;
	readonly global_listeners: Map<ListenerID, GlobalKeywordHandler>;
	readonly kwl_listeners: Map<
		KWLName<"full">,
		{
			complete: Record<
				string,
				{
					handler: KWLHandler;
					execution_strategy: ExecutionStrategy;
					permanent: boolean;
				}
			>;
			partial: {
				[kw_name: string]: Record<
					string,
					{
						handler: KeywordHandler;
						execution_strategy: ExecutionStrategy;
						permanent: boolean;
					}
				>;
			};
		}
	>;
	private lazy_handler_interval;
	readonly pending_lazy_updates: {
		kwls: Map<ListenerID, KWLHandler>;
		kws: Map<ListenerID, [handler: KeywordHandler, payload: KeywordPayload]>;
	};
	constructor(m_error_handler: (err: any) => void);
	dump_stats(): void;
	close(): void;
	prune_listeners(
		keep_if: (pars: {
			kwl?: KWLName<"full">;
			kw?: SysName;
			listener_id: ListenerID;
		}) => boolean,
	): void;
	private execute_lazy_handlers;
	safely_delete_handler(pars: {
		kwl: KWLName<"full">;
		kw?: SysName;
		id: ListenerID;
	}): void;
	private do_get_listeners;
	have_permanent_listener(pars: {
		kwl: KWLName<"full">;
		kw?: SysName;
	}): boolean;
	register_kw_listener<T extends KeywordPayload = KeywordPayload>(
		pars: {
			kwl: KWLName<"full">;
			kw: SysName;
			listener_id?: ListenerID;
			cache?: boolean;
			listener_type: KeywordListenerType;
			execution_strategy: ExecutionStrategy;
			ensure_initial_read?: boolean;
		},
		handler: KeywordHandler<T>,
	): KeywordListener;
	register_kwl_listener(
		pars: {
			kwl: KWLName<"full">;
			listener_id?: ListenerID;
			cache?: boolean;
			listener_type: KeywordListenerType;
			execution_strategy: ExecutionStrategy;
			ensure_initial_read?: boolean;
		},
		handler: KWLHandler,
	): KWLListener;
	register_global_listener(
		handler: GlobalKeywordHandler,
		pars?: {
			listener_id?: ListenerID;
		},
	): GlobalListener;
}
