import { enforce_nonnull } from "./utilities.js";
export const MissingData = Symbol("missing");
export function to_full_kwl(this_kwl, relative_kwl) {
	if (void 0 !== relative_kwl) {
		return `${null === this_kwl ? "" : `${this_kwl}.`}${relative_kwl}`;
	}
	return this_kwl;
}
export function component_of_kwl(kwl) {
	const i = kwl.indexOf(".");
	return -1 !== i ? kwl.substring(0, i) : kwl;
}
export class Watcher {
	path;
	destructor;
	constructor(path, destructor) {
		(this.path = path), (this.destructor = destructor);
	}
	unwatch() {
		this.destructor();
	}
}
export var ExecutionStrategy;
!(function (ExecutionStrategy) {
	(ExecutionStrategy[(ExecutionStrategy.Immediate = 0)] = "Immediate"),
		(ExecutionStrategy[(ExecutionStrategy.Lazy = 1)] = "Lazy");
})(ExecutionStrategy || (ExecutionStrategy = {}));
export var KeywordListenerType;
!(function (KeywordListenerType) {
	(KeywordListenerType[(KeywordListenerType.Permanent = 0)] = "Permanent"),
		(KeywordListenerType[(KeywordListenerType.OneShot = 1)] = "OneShot");
})(KeywordListenerType || (KeywordListenerType = {}));
export class GlobalListener {
	id;
	destructor;
	constructor(id, destructor) {
		(this.id = id), (this.destructor = destructor);
	}
	unregister() {
		this.destructor(this);
	}
}
export class KWLListener {
	kwl;
	id;
	listener_registry;
	constructor(kwl, id, listener_registry) {
		(this.kwl = kwl),
			(this.id = id),
			(this.listener_registry = listener_registry);
	}
	unregister() {
		this.listener_registry
			.deref()
			?.safely_delete_handler({ kwl: this.kwl, id: this.id });
	}
}
export class KeywordListener {
	kwl;
	kw;
	id;
	listener_registry;
	constructor(kwl, kw, id, listener_registry) {
		(this.kwl = kwl),
			(this.kw = kw),
			(this.id = id),
			(this.listener_registry = listener_registry);
	}
	unregister() {
		this.listener_registry
			.deref()
			?.safely_delete_handler({ kwl: this.kwl, kw: this.kw, id: this.id });
	}
}
export var EventHandlerType;
!(function (EventHandlerType) {
	(EventHandlerType[(EventHandlerType.Open = 0)] = "Open"),
		(EventHandlerType[(EventHandlerType.Close = 1)] = "Close"),
		(EventHandlerType[(EventHandlerType.Error = 2)] = "Error"),
		(EventHandlerType[(EventHandlerType.ComponentStateChange = 3)] =
			"ComponentStateChange");
})(EventHandlerType || (EventHandlerType = {}));
export class EventHandler {
	handler_type;
	id;
	destructor;
	constructor(handler_type, id, destructor) {
		(this.handler_type = handler_type),
			(this.id = id),
			(this.destructor = destructor);
	}
	unregister() {
		this.destructor();
	}
}
export class TimeoutContext {
	state;
	desc = null;
	constructor(state) {
		this.state = state;
	}
	get timed_out() {
		return this.state.timed_out;
	}
	register_timeout_handler(f) {
		this.state.timeout_handlers.push(f);
	}
	unregister_timeout_handler(f) {
		const remaining = [];
		for (const g of this.state.timeout_handlers) f !== g && remaining.push(g);
		this.state.timeout_handlers = remaining;
	}
}
export function with_timeout(timeout, handler) {
	return new Promise((resolve, reject) => {
		const internal_state = { timed_out: !1, timeout_handlers: [] },
			context = new TimeoutContext(internal_state),
			timer = setTimeout(() => {
				const suffix = null === context.desc ? "" : ` (${context.desc})`;
				internal_state.timed_out = !0;
				for (const f of internal_state.timeout_handlers.reverse()) f();
				reject(new Error(`Timeout after ${timeout.ms()} ms${suffix}`));
			}, timeout.ms());
		handler(context)
			.then((success) => {
				clearTimeout(timer), internal_state.timed_out || resolve(success);
			})
			.catch((err) => {
				clearTimeout(timer), internal_state.timed_out || reject(err);
			});
	});
}
