/// <reference types="node" />
import { Duration } from "../time.js";
type DownloadParameters = {
	port?: number;
	ip: string;
	path: string;
	timeout: Duration;
} & (
	| {
			protocol: "http";
	  }
	| {
			protocol: "https";
			reject_unauthorized: boolean;
	  }
);
export declare function download<Kind extends "string" | "Buffer" = "string">(
	pars: DownloadParameters,
	kind?: Kind,
): Promise<Kind extends "Buffer" ? Buffer : string>;
export declare function download_json(pars: DownloadParameters): Promise<any>;
export {};
