import { get as http_get } from "http";
import { get as https_get } from "https";
import { gunzipSync } from "zlib";
import { enforce } from "../utilities.js";
export function download(pars, kind) {
	const finish_buffer = (x) =>
		x instanceof Buffer
			? "string" !== (kind ?? "string")
				? x
				: x.toString("utf-8")
			: "string" === (kind ?? "string")
				? x
				: Buffer.from(x, "utf-8");
	let data;
	const port = pars.port ?? ("http" === pars.protocol ? 80 : 443);
	return new Promise((resolve, reject) => {
		const cb = (res) => {
				if (200 === res.statusCode)
					res
						.on("data", (chunk) => {
							void 0 === data
								? (data = chunk)
								: "string" == typeof data
									? (res.setEncoding("utf8"), (data += chunk))
									: (data = Buffer.concat([data, chunk]));
						})
						.on("end", () => {
							"gzip" == (res.headers["content-encoding"] ?? "")
								? resolve(finish_buffer(gunzipSync(data)))
								: (Buffer, resolve(finish_buffer(data)));
						});
				else {
					let msg =
						res.statusMessage ??
						(res.statusCode ? `Error ${res.statusCode}` : "");
					msg.length > 0 && (msg = ": " + msg),
						reject(
							`Unable to download ${pars.protocol}://${pars.ip}:${port}/${pars.path}${msg}`,
						);
				}
			},
			common_pars = {
				hostname: pars.ip,
				port: port,
				protocol: pars.protocol + ":",
				path: pars.path.startsWith("/") ? pars.path : `/${pars.path}`,
				headers: { "Accept-Encoding": "gzip" },
				timeout: pars.timeout.ms(),
				...("http" === pars.protocol
					? {}
					: { rejectUnauthorized: pars.reject_unauthorized ?? !0 }),
			},
			inject_error_handlers = (req) => {
				const prefix = `Unable to download ${pars.protocol}://${pars.ip}:${port}/${pars.path}`;
				req
					.on("error", (err) => reject(`${prefix}: ${err.message}`))
					.on("close", () =>
						reject(`${prefix}: Connection unexpectedly closed`),
					)
					.on("abort", () =>
						reject(`${prefix}: Connection aborted unexpectedly`),
					);
			};
		switch (pars.protocol) {
			case "http":
				inject_error_handlers(http_get(common_pars, cb));
				break;
			case "https":
				inject_error_handlers(
					https_get(
						{
							...common_pars,
							rejectUnauthorized: pars.reject_unauthorized ?? !0,
						},
						cb,
					),
				);
		}
	});
}
export async function download_json(pars) {
	return JSON.parse(await download(pars));
}
