import { WebSocket } from "ws";
export function binary_concat(header, msg) {
	return Buffer.concat([header, msg]);
}
export class Adapter {
	socket;
	constructor(pars) {
		try {
			const port_suffix = pars.port ? `:${pars.port}` : "",
				url = `${pars.protocol ?? "ws"}://${pars.ip}${port_suffix}/socket`,
				socket_opts = {
					ip: pars.ip,
					towel: pars.towel,
					servername: "",
					maxPayload: pars.max_payload_size ?? 1048576,
					rejectUnauthorized: pars.reject_unauthorized,
					...(pars.login
						? { auth: `${pars.login.user}:${pars.login.password}` }
						: {}),
				},
				listeners = {
					"unexpected-response": (_, rsp) => {
						if (401 === rsp.statusCode && "Unauthorized" === rsp.statusMessage)
							pars.reject(
								new Error(
									`Unable to connect to ${pars.ip}; this machine appears to be password-protected (try specifying the login parameter within your VM.open or VSocket.open call)`,
								),
							);
						else {
							const s_code =
									void 0 !== rsp.statusCode
										? `status code: ${rsp.statusCode}`
										: "",
								s_msg =
									void 0 !== rsp.statusCode
										? `status message: ${rsp.statusMessage}`
										: "",
								suffix =
									s_code.length + s_msg.length === 0
										? ""
										: `(${s_code}${0 !== Math.min(s_code.length, s_msg.length) ? ", " : ""}${s_msg})`;
							pars.reject(
								new Error(
									`Connection attempt aborted; got unexpected response${suffix}`,
								),
							);
						}
					},
					error: (err) => {
						pars.reject(err);
					},
					close: (_, code, reason) => {
						pars.reject(
							new Error(
								`WebSocket connection to ${pars.ip} unexpectedly closed (code ${code}, reason ${reason})`,
							),
						);
					},
				};
			(this.socket = new WebSocket(url, {
				...socket_opts,
				handshakeTimeout: pars.timeout.ms(),
				skipUTF8Validation: !0,
			})
				.addListener("unexpected-response", listeners["unexpected-response"])
				.on("error", listeners.error)
				.on("close", listeners.close)
				.on("open", () => {
					this.socket.on("error", pars.on_error).on("close", pars.on_close);
				})),
				(this.socket.onmessage = (msg) => {
					(this.socket.onmessage = pars.on_further_msg),
						pars.on_first_msg(msg.data);
				});
		} catch (e) {
			pars.reject(e);
		}
	}
	send(data) {
		this.socket.send(data);
	}
	close() {
		this.socket.removeAllListeners(), this.socket.terminate();
	}
}
