import { download_json } from "./polyfills/polyfill_http.js";
export class ResourceCache {
	storage = {};
	clients = {};
	async retrieve(pars) {
		if (Object.prototype.hasOwnProperty.call(this.storage, pars.key))
			return this.storage[pars.key];
		let should_download = !1;
		Object.prototype.hasOwnProperty.call(this.clients, pars.key) ||
			((this.clients[pars.key] = []), (should_download = !0));
		const result = new Promise((resolve, reject) => {
			this.clients[pars.key].push({ resolve: resolve, reject: reject });
		});
		if (should_download) {
			try {
				const payload = await download_json(pars);
				this.storage[pars.key] = payload;
				for (const client of this.clients[pars.key]) client.resolve(payload);
			} catch (e) {
				for (const client of this.clients[pars.key]) client.reject(e);
			}
			delete this.clients[pars.key];
		}
		return result;
	}
}
