import { enforce } from "./utilities.js";
export function indices(rowmask) {
	const nibble_count = rowmask.length,
		indices = [];
	for (let i_nibble = 0; i_nibble < nibble_count; i_nibble++) {
		let cur_idx = 4 * i_nibble;
		const char_code = rowmask.charCodeAt(i_nibble);
		let value = char_code >= 65 ? char_code - 55 : char_code - 48;
		for (; value > 0; )
			1 & ~value || indices.push(cur_idx), (value >>>= 1), (cur_idx += 1);
	}
	return indices;
}
export function has_index(rowmask, i) {
	const i_nibble = i >>> 2;
	if (i_nibble >= rowmask.length) return !1;
	const char_code = rowmask.charCodeAt(i_nibble);
	return !!(
		((char_code >= 65 ? char_code - 55 : char_code - 48) >>> (i % 4)) &
		1
	);
}
