import {
	Subtree,
	SubtreeNamedTable,
	VSettings,
	VSocket,
} from "./data_views.js";
import { BranchName, KWLName } from "./pervasives.js";
import {
	ComponentDescription,
	ContainerizedSubtreeDescription,
	KeywordDescription,
	Schema,
	SubtreeDescription,
	Typedef,
} from "./schema_v2.js";
import { WorkQueue } from "./utilities.js";
export declare function subtree_iter<
	BackingStore extends VSocket | VSettings,
>(pars: {
	backing_store: BackingStore;
	on_subtree?: (
		st: Subtree<BackingStore>,
	) => Promise<"recurse" | "do-not-recurse">;
	on_named_table?: (
		st: SubtreeNamedTable<BackingStore>,
	) => Promise<"recurse" | "do-not-recurse">;
	include: "allocated" | "everything";
	check_component_liveness?: boolean;
	include_disabled?: boolean;
	work_queue?: WorkQueue;
}): Promise<void>;
export declare function subtree_iter_sync<
	BackingStore extends VSocket | VSettings,
>(pars: {
	backing_store: BackingStore;
	handler: (
		description:
			| SubtreeDescription<"annotated">
			| ComponentDescription<"annotated">,
		kwl: KWLName<"full">,
	) => "recurse" | "do-not-recurse";
	include: "everything";
	include_disabled?: boolean;
}): void;
export declare function subtree_iter_typewise<
	T,
	BackingStore extends VSocket | VSettings,
>(
	backing_store: BackingStore,
	pars: {
		type_identifier: string;
		lift: (st: Subtree<BackingStore>) => T;
		handler: (t: T, kwl: KWLName<"full">) => Promise<void>;
		include?: "allocated" | "everything";
		work_queue?: WorkQueue;
		check_component_liveness?: boolean;
	},
): Promise<void>;
export declare function keyword_iter<
	BackingStore extends VSocket | VSettings,
>(pars: {
	backing_store: BackingStore;
	handler: (
		backing_store: BackingStore,
		description: KeywordDescription<"annotated">,
		kwl: KWLName<"full">,
	) => Promise<void>;
	include?: "allocated" | "everything";
	work_queue?: WorkQueue;
	check_component_liveness?: boolean;
	include_rowname_keywords?: boolean;
}): Promise<void>;
export declare function keyword_iter_sync<
	BackingStore extends VSocket | VSettings,
>(pars: {
	backing_store: BackingStore;
	handler: (
		backing_store: BackingStore,
		description: KeywordDescription<"annotated">,
		kwl: KWLName<"full">,
	) => void;
	include?: "everything";
	include_rowname_keywords?: boolean;
}): void;
export declare function branch_iter<
	BackingStore extends VSocket | VSettings,
>(pars: {
	backing_store: BackingStore;
	handler: (
		branch: BranchName,
		description:
			| ContainerizedSubtreeDescription<"annotated">
			| ComponentDescription<"annotated">,
	) => Promise<"recurse" | "do-not-recurse">;
	include_disabled?: boolean;
}): Promise<void>;
export declare function branch_iter_sync<
	BackingStore extends VSocket | VSettings,
>(pars: {
	backing_store: BackingStore;
	handler: (
		branch: BranchName,
		description:
			| ContainerizedSubtreeDescription<"annotated">
			| ComponentDescription<"annotated">,
	) => "recurse" | "do-not-recurse";
	include_disabled?: boolean;
}): void;
export declare function reset_subtree_to_defaults<
	BackingStore extends VSocket | VSettings,
>(
	backing_store: BackingStore,
	kwl: KWLName<"full">,
	st: SubtreeDescription<"annotated">,
	pars?: {
		wq?: WorkQueue;
		drain_wq?: boolean;
		recursive?: boolean;
	},
): Promise<void>;
export declare function compute_persistence_hash(
	schema: Schema<"raw">,
): Promise<Uint8Array>;
export type DiffItem<T> =
	| {
			kind: "removed";
			was: T;
	  }
	| {
			kind: "added";
			is: T;
	  }
	| {
			kind: "scalar-changed";
			was: T;
			is: T;
	  }
	| {
			kind: "record-changed";
			changes: Record<string, DiffItem<T>>;
	  };
export declare function extract_persistent_parts(
	schema: Schema<"raw">,
): Schema<"raw">;
export declare function reify_typedefs(schema: Schema<"raw">): Schema<"raw">;
export declare function schema_diff(
	a: Schema<"raw">,
	b: Schema<"raw">,
	pars?: {
		ignored_properties?: Set<string>;
		dontrecurse?: Set<string>;
	},
): {
	constants: Record<
		string,
		DiffItem<{
			[constant_name: string]: import("./pervasives.js").ConstantDescription;
		}>
	>;
	typedefs: Record<string, DiffItem<Typedef<"raw">>>;
	keywords: Record<
		string,
		DiffItem<
			SubtreeDescription<"raw"> & {
				ua_name: string;
				owning_module: string;
				bound_to?: string[] | undefined;
			}
		>
	>;
};
