import { enforce } from "./utilities.js";
export function children_of_raw_subtree(schema, st) {
	if ("children" in st) return st.children;
	{
		const td = schema.typedefs[st.type_identifier];
		return "children" in td ? td.children : [];
	}
}
export function children_of_raw_atomic_subtree(schema, st) {
	if ("children" in st) return st.children;
	{
		const td = schema.typedefs[st.type_identifier];
		return "atomic subtree" === td.data_type && "children" in td
			? td.children
			: [];
	}
}
