import * as V1 from "./schema_v1.js";
export function is_v2(schema) {
	return "versions" in schema;
}
export function ensure_v2(schema) {
	return is_v2(schema)
		? schema
		: (function (schema) {
				const atomic_multiplicity_of = (m, optional) => {
						const atomic_multiplicity = [];
						return (
							"vector_size" in m &&
								atomic_multiplicity.push({
									type: "vector",
									capacity: m.vector_size,
								}),
							"array_size" in m &&
								atomic_multiplicity.push({
									type: "array",
									capacity: m.array_size,
								}),
							optional && atomic_multiplicity.push({ type: "optional" }),
							atomic_multiplicity
						);
					},
					convert_atomic_field = (af) => {
						const atomic_multiplicity = atomic_multiplicity_of(af, af.optional),
							tmp =
								"atomic subtree" === af.data_type
									? {
											...af,
											children: V1.children_of_raw_atomic_subtree(
												schema,
												af,
											).map(convert_atomic_field),
											atomic_multiplicity: atomic_multiplicity,
										}
									: { ...af, atomic_multiplicity: atomic_multiplicity };
						return delete tmp.optional, tmp;
					},
					convert_keyword = (kw) => {
						const atomic_multiplicity = atomic_multiplicity_of(kw, kw.optional);
						return "atomic subtree" === kw.data_type
							? {
									...kw,
									children: V1.children_of_raw_atomic_subtree(schema, kw).map(
										convert_atomic_field,
									),
									atomic_multiplicity: atomic_multiplicity,
								}
							: { ...kw, atomic_multiplicity: atomic_multiplicity };
					},
					convert_typedef = (td) => {
						switch (td.data_type) {
							case "subtree":
								return {
									...td,
									children: V1.children_of_raw_subtree(schema, td).map(
										(child) =>
											"subtree" === child.data_type
												? convert_subtree(child)
												: convert_keyword(child),
									),
								};
							case "atomic subtree":
								return {
									...td,
									atomic_multiplicity: atomic_multiplicity_of(td, td.optional),
									children: V1.children_of_raw_atomic_subtree(schema, td).map(
										convert_atomic_field,
									),
								};
							default:
								return {
									...td,
									atomic_multiplicity: atomic_multiplicity_of(td, td.optional),
								};
						}
					},
					convert_subtree = (st) => ({
						...st,
						children: V1.children_of_raw_subtree(schema, st).map((child) =>
							"subtree" === child.data_type
								? convert_subtree(child)
								: convert_keyword(child),
						),
					}),
					result = {
						versions: { format: 2 },
						constants: schema.constants,
						error_feedback_channels: schema.error_feedback_channels.map(
							(efc) => ({ kwl: efc.kwl, owner: efc.owner }),
						),
						keywords: schema.keywords.map((comp) => {
							const children = [];
							for (const child of V1.children_of_raw_subtree(schema, comp))
								"subtree" === child.data_type
									? children.push(convert_subtree(child))
									: children.push(convert_keyword(child));
							return { ...comp, children: children };
						}),
						typedef_identifiers: schema.typedef_identifiers,
						typedefs: {},
						units: {},
					};
				for (const td in schema.typedefs)
					result.typedefs[td] = convert_typedef(schema.typedefs[td]);
				return result;
			})(schema);
}
