export class SoftwareVersion {
	major;
	minor;
	patch;
	branch;
	commit;
	constructor(major, minor, patch, branch, commit) {
		(this.major = major),
			(this.minor = minor),
			(this.patch = patch),
			(this.branch = branch),
			(this.commit = commit);
	}
	static from_string(swv) {
		const m = swv.match(/^([0-9]+)\.([0-9]+)(\.([^_]+))?$/);
		if (null !== m)
			return new SoftwareVersion(
				parseInt(m[1]),
				parseInt(m[2]),
				m.length > 4 ? parseInt(m[4]) : 0,
				"stable",
			);
		{
			const m = swv.match(/^([0-9]+)\.([0-9]+)\.([0-9]+)_([^_]+)/);
			if (null === m)
				throw new Error(
					`Unable to interpret ${swv} as a software version string`,
				);
			return new SoftwareVersion(
				parseInt(m[1]),
				parseInt(m[2]),
				parseInt(m[3]),
				m[4],
			);
		}
	}
	to_string() {
		const prefix = `${this.major}.${this.minor}.${this.patch}`;
		return "stable" === this.branch ? prefix : `${prefix}_${this.branch}`;
	}
	is_atleast(other) {
		return (
			this.compare(
				"string" == typeof other ? SoftwareVersion.from_string(other) : other,
			) >= 0
		);
	}
	compare(other) {
		return this.major > other.major
			? 1
			: this.major < other.major
				? -1
				: this.minor > other.minor
					? 1
					: this.minor < other.minor
						? -1
						: this.patch > other.patch
							? 1
							: this.patch < other.patch
								? -1
								: void 0 === other.commit
									? void 0 === this.commit
										? 0
										: 1
									: void 0 === this.commit
										? -1
										: this.commit > other.commit
											? 1
											: this.commit < other.commit
												? -1
												: 0;
	}
}
