type Unit = "s" | "ms" | "µs" | "ns";
export declare class Duration {
	private readonly unit;
	private readonly value;
	static abs(x: Duration): Duration;
	constructor(x: number, unit: Unit | "us" | "min" | "h");
	static from_string(raw_input: string): Duration | undefined;
	plus(other: Duration): Duration;
	minus(other: Duration): Duration;
	divide_by<T extends number | Duration>(
		x: T,
	): T extends number ? Duration : number;
	times(x: number): Duration;
	ns_rounded(): number;
	ns(): number;
	us(): number;
	ms(): number;
	s(): number;
	toString(mode?: "precise" | "convenient"): string;
	equal(other: Duration): boolean;
	static max(x: Duration, ...ys: Duration[]): Duration;
	static min(x: Duration, ...ys: Duration[]): Duration;
}
export declare class Timestamp {
	private ns_total;
	constructor(x: number | string | bigint);
	nanoseconds(): number;
	seconds(): number;
	/** a.distance_to(b) = b - a */
	distance_to(other: Timestamp): Duration;
	/** a.distance_from(b) = a - b */
	distance_from(other: Timestamp): Duration;
	plus(d: Duration): Timestamp;
	minus(d: Duration): Timestamp;
	toString(mode?: "backend-style" | "convenient"): string;
	toNumber(): number;
	toNSBigInt(): bigint;
	toJSON(): string;
	/** compares timestamps to single-ns precision if both are string-typed,
        otherwise up to floating-point accuracy (~200ns for timestamps around the year 2020) */
	equal(other: Timestamp): boolean;
}
export {};
