import {
	Subtree,
	SubtreeArray,
	SubtreeNamedTable,
	SubtreeTable,
	VSettings,
	VSocket,
} from "./data_views.js";
import {
	KeywordPayload,
	KWLName,
	MaybeSparseArray,
	SysName,
} from "./pervasives.js";
import { Duration, Timestamp } from "./time.js";
import {
	Referenceable,
	RefinedIndexedMutatingReference,
	RefinedIndexedNonmutatingReference,
	RefinedMutatingReference,
	RefinedNonmutatingReference,
	StronglyTypedSubtree,
	TypeConverters,
	wKeyword,
} from "./voverlays.js";
export declare function get_subtree(
	socket: VSocket,
	kwl: KWLName<"full">,
): Subtree<VSocket>;
export declare function component_checked(
	socket: VSocket,
	expected_sys_name: string,
): Subtree<VSocket> | null;
export declare function subtree_child_checked(
	subtree: Subtree<VSocket>,
	child_index: number,
	expected_sys_name: SysName,
): Subtree<VSocket>;
export declare function subtree_table_child_checked(
	subtree: Subtree<VSocket>,
	child_index: number,
	expected_sys_name: SysName,
): SubtreeTable<VSocket>;
export declare function subtree_named_table_child_checked(
	subtree: Subtree<VSocket>,
	child_index: number,
	expected_sys_name: SysName,
): SubtreeNamedTable<VSocket>;
export declare function subtree_array_child_checked(
	subtree: Subtree<VSocket>,
	child_index: number,
	expected_sys_name: SysName,
): SubtreeArray<VSocket>;
export declare function liftOrLowerNullable<T, S>(
	f: (payload: T, socket: VSocket) => S,
): (maybe_payload: T | null, socket: VSocket) => S | null;
export declare function liftNanoseconds(payload: number, _: VSocket): Duration;
export declare function liftSeconds(payload: number, _: VSocket): Duration;
export declare function liftTimestamp(
	payload: string | number,
	_: VSocket,
): Timestamp;
export declare function lowerTimestamp(
	ts: Timestamp,
	_: VSocket,
): string | number;
export declare function lowerNanoseconds(payload: Duration, _: VSocket): number;
export declare function lowerSeconds(payload: Duration, _: VSocket): number;
export declare function liftArray<T, S>(
	f: (raw: T, socket: VSocket) => S,
): (raw_elems: Array<T>, socket: VSocket) => Array<S>;
export declare function mapMaybeSparseArray<T, S>(
	raw_elems: MaybeSparseArray<T>,
	f: (x: T) => S,
): MaybeSparseArray<S>;
export declare function liftMaybeSparseArray<T, S>(
	f: (raw: T, socket: VSocket) => S,
): (raw_elems: MaybeSparseArray<T>, socket: VSocket) => MaybeSparseArray<S>;
export declare function liftNullable<T, S>(
	f: (raw: T, socket: VSocket) => S,
): (maybe_x: T | null, socket: VSocket) => S | null;
export declare function lowerArray<T, S>(
	f: (payload: T, socket: VSocket) => S,
): (elems: T[], socket: VSocket) => S[];
export declare function lowerNullableArray<T, S>(
	f: (raw: T, socket: VSocket) => S,
): (raw_elems: T[] | null, socket: VSocket) => S[] | null;
export declare function liftRefinedMutatingReference<
	BackingStore extends VSocket | VSettings,
	member_name extends string,
	LongType extends string,
	ParentType extends Referenceable<LongType> &
		StronglyTypedSubtree<BackingStore>,
	ScalarRawType extends KeywordPayload,
	ScalarUserType,
>(
	f: (kwl: KWLName<"full">, backing_store: BackingStore) => ParentType,
	member_name: SysName,
	type_converters: TypeConverters<BackingStore, ScalarRawType, ScalarUserType>,
): (
	path: string | null,
	backing_store: BackingStore,
) => RefinedMutatingReference<
	BackingStore,
	member_name,
	LongType,
	ParentType,
	ScalarRawType,
	ScalarUserType
> | null;
export declare function liftRefinedIndexedMutatingReference<
	BackingStore extends VSocket | VSettings,
	member_name extends string,
	LongType extends string,
	ParentType extends Referenceable<LongType> &
		StronglyTypedSubtree<BackingStore>,
	ScalarRawType extends KeywordPayload,
	ScalarUserType,
>(
	f: (kwl: KWLName<"full">, backing_store: BackingStore) => ParentType,
	member_name: SysName,
	type_converters: TypeConverters<BackingStore, ScalarRawType, ScalarUserType>,
): (
	path: string | null,
	backing_store: BackingStore,
) => RefinedIndexedMutatingReference<
	BackingStore,
	member_name,
	LongType,
	ParentType,
	ScalarRawType,
	ScalarUserType
> | null;
export declare function liftRefinedNonmutatingReference<
	BackingStore extends VSocket | VSettings,
	member_name extends string,
	LongType extends string,
	ParentType extends Referenceable<LongType> &
		StronglyTypedSubtree<BackingStore>,
	ScalarRawType extends KeywordPayload,
	ScalarUserType,
>(
	f: (kwl: KWLName<"full">, backing_store: BackingStore) => ParentType,
	member_name: SysName,
	type_converters: TypeConverters<BackingStore, ScalarRawType, ScalarUserType>,
): (
	path: string | null,
	backing_store: BackingStore,
) => RefinedNonmutatingReference<
	BackingStore,
	member_name,
	LongType,
	ParentType,
	ScalarRawType,
	ScalarUserType
> | null;
export declare function liftRefinedIndexedNonmutatingReference<
	BackingStore extends VSocket | VSettings,
	member_name extends string,
	LongType extends string,
	ParentType extends Referenceable<LongType> &
		StronglyTypedSubtree<BackingStore>,
	ScalarRawType extends KeywordPayload,
	ScalarUserType,
>(
	f: (kwl: KWLName<"full">, backing_store: BackingStore) => ParentType,
	member_name: SysName,
	type_converters: TypeConverters<BackingStore, ScalarRawType, ScalarUserType>,
): (
	path: string | null,
	backing_store: BackingStore,
) => RefinedIndexedNonmutatingReference<
	BackingStore,
	member_name,
	LongType,
	ParentType,
	ScalarRawType,
	ScalarUserType
> | null;
export declare function lowerRefinedReference<
	BackingStore extends VSocket | VSettings,
	member_name extends string,
	LongType extends string,
	ParentType extends Referenceable<LongType> &
		StronglyTypedSubtree<BackingStore>,
	ScalarRawType extends KeywordPayload,
	ScalarUserType,
>(): (
	maybe_ref:
		| null
		| RefinedMutatingReference<
				BackingStore,
				member_name,
				LongType,
				ParentType,
				ScalarRawType,
				ScalarUserType
		  >
		| RefinedNonmutatingReference<
				BackingStore,
				member_name,
				LongType,
				ParentType,
				ScalarRawType,
				ScalarUserType
		  >,
	_: VSocket,
) => string | null;
export declare function lowerRefinedIndexedReference<
	BackingStore extends VSocket | VSettings,
	member_name extends string,
	LongType extends string,
	ParentType extends Referenceable<LongType> &
		StronglyTypedSubtree<BackingStore>,
	ScalarRawType extends KeywordPayload,
	ScalarUserType,
>(): (
	maybe_ref:
		| null
		| RefinedIndexedMutatingReference<
				BackingStore,
				member_name,
				LongType,
				ParentType,
				ScalarRawType,
				ScalarUserType
		  >
		| RefinedIndexedNonmutatingReference<
				BackingStore,
				member_name,
				LongType,
				ParentType,
				ScalarRawType,
				ScalarUserType
		  >,
	_: VSocket,
) => string | null;
export declare function legacy_table_resize<
	T,
	_KW0 extends StronglyTypedSubtree<VSocket>,
	_KW1 extends StronglyTypedSubtree<VSocket>,
>(pars: {
	table: {
		rows(): Promise<T[]>;
		allocated_indices(): Promise<number[]>;
	};
	add_row: wKeyword<VSocket, "Click", "Click", _KW0>;
	delete_row: (index: number) => wKeyword<VSocket, "Click", "Click", _KW1>;
	n: number;
	retry_interval?: Duration;
}): Promise<void>;
