import {
	Subtree,
	SubtreeArray,
	SubtreeNamedTable,
	SubtreeNamedTableRow,
	SubtreeTable,
	VSettings,
	VSocket,
} from "./data_views.js";
import {
	CommonCommandOptions,
	CommonWriteOptions,
	KeywordPayload,
	SysName,
	WaitUntilOptions,
	Watcher,
	WriteOptions,
	WriteValidator,
} from "./pervasives.js";
export interface IReadableKeyword<T> {
	read: () => Promise<T>;
	wait_until: (
		criterion: (payload: T) => boolean,
		opts?: WaitUntilOptions,
	) => Promise<T>;
	watch: (
		handler: (payload: T) => void,
		opts?: CommonCommandOptions & {
			defer_subscription?: boolean;
		},
	) => Promise<Watcher>;
}
export interface IWritableKeyword<T> {
	write: (payload: T, opts?: WriteOptions<T>) => Promise<void>;
}
export type AnchoredWriteValidator<ParentType, UserWriteType> = (
	parent: ParentType,
	command_payload: UserWriteType,
) => WriteValidator<UserWriteType>;
export interface Referenceable<typename extends string> {
	type_identifier: typename;
}
export interface StronglyTypedSubtree<
	BackingStore extends VSocket | VSettings,
> {
	readonly raw: Subtree<BackingStore>;
}
export declare function reset_to_defaults<
	BackingStore extends VSocket | VSettings,
>(x: StronglyTypedSubtree<BackingStore>): Promise<void>;
export declare function same<
	BackingStore extends VSocket | VSettings,
	T1 extends StronglyTypedSubtree<BackingStore>,
	T2 extends StronglyTypedSubtree<BackingStore>,
>(a: T1 | null, b: T2 | null): boolean;
type TypeConverter<
	BackingStore extends VSocket | VSettings,
	RawType,
	UserType,
> = (payload: RawType, backing_store: BackingStore) => UserType;
export interface TypeConverters<
	BackingStore extends VSocket | VSettings,
	RawType,
	UserType,
> {
	lift: TypeConverter<BackingStore, RawType, UserType>;
	lower: TypeConverter<BackingStore, UserType, RawType>;
}
export type SubtreeLift<
	BackingStore extends VSocket | VSettings,
	S extends StronglyTypedSubtree<BackingStore>,
> = (raw: Subtree<BackingStore>, backing_store: BackingStore) => S;
export declare function nullableLiftOrLower<
	BackingStore extends VSocket | VSettings,
	T1,
	T2,
>(
	liftOrLower: (payload: T1, backing_store: BackingStore) => T2,
): (payload: T1 | null, backing_store: BackingStore) => T2 | null;
export declare class rKeyword<
	BackingStore extends VSocket | VSettings,
	RawReadType extends KeywordPayload,
	UserReadType,
	ParentType extends StronglyTypedSubtree<BackingStore>,
> implements IReadableKeyword<UserReadType>
{
	readonly parent: ParentType;
	protected readonly m_kw: SysName;
	protected readonly m_read_converters: TypeConverters<
		BackingStore,
		RawReadType,
		UserReadType
	>;
	constructor(
		parent: ParentType,
		m_kw: SysName,
		m_read_converters: TypeConverters<BackingStore, RawReadType, UserReadType>,
	);
	read(
		opts?: CommonCommandOptions & {
			use_cache_if_present?: boolean;
		},
	): Promise<UserReadType>;
	wait_until(
		criterion: (payload: UserReadType) => boolean,
		opts?: WaitUntilOptions,
	): Promise<UserReadType>;
	watch(
		handler: (payload: UserReadType) => void,
		opts?: CommonCommandOptions & {
			defer_subscription?: boolean;
		},
	): Promise<Watcher>;
}
export declare class rKeywordReferenceable<
	BackingStore extends VSocket | VSettings,
	member_name extends string,
	ScalarRawReadType extends KeywordPayload,
	ScalarUserReadType,
	RawReadType extends KeywordPayload[],
	UserReadType extends ScalarUserReadType[],
	ParentLongType extends string,
	ParentType extends Referenceable<ParentLongType> &
		StronglyTypedSubtree<BackingStore>,
> extends rKeyword<BackingStore, RawReadType, UserReadType, ParentType> {
	private readonly m_scalar_read_converters;
	constructor(
		parent: ParentType,
		m_kw: SysName,
		m_scalar_read_converters: TypeConverters<
			BackingStore,
			ScalarRawReadType,
			ScalarUserReadType
		>,
		m_read_converters: TypeConverters<BackingStore, RawReadType, UserReadType>,
	);
	reference_to_index(
		index: number,
	): RefinedIndexedNonmutatingReference<
		BackingStore,
		member_name,
		ParentLongType,
		ParentType,
		ScalarRawReadType,
		ScalarUserReadType
	>;
}
export declare class riKeyword<
	BackingStore extends VSocket | VSettings,
	ScalarRawReadType extends KeywordPayload,
	ScalarUserReadType,
	ParentType extends StronglyTypedSubtree<BackingStore>,
> implements IReadableKeyword<ScalarUserReadType | null>
{
	readonly parent: ParentType;
	protected readonly m_kw: SysName;
	readonly index: number;
	protected readonly m_lift: TypeConverter<
		BackingStore,
		ScalarRawReadType,
		ScalarUserReadType
	>;
	protected extract(
		payload: ScalarRawReadType[] | null,
		backing_store: BackingStore,
	): ScalarUserReadType;
	constructor(
		parent: ParentType,
		m_kw: SysName,
		index: number,
		read_converters: TypeConverters<
			BackingStore,
			ScalarRawReadType,
			ScalarUserReadType
		>,
	);
	read(
		opts?: CommonCommandOptions & {
			use_cache_if_present?: boolean;
		},
	): Promise<ScalarUserReadType>;
	wait_until(
		criterion: (payload: null | ScalarUserReadType) => boolean,
		opts?: WaitUntilOptions,
	): Promise<ScalarUserReadType>;
	watch(
		handler: (payload: null | ScalarUserReadType) => void,
		opts?: CommonCommandOptions & {
			defer_subscription?: boolean;
		},
	): Promise<Watcher>;
}
export declare class wKeyword<
	BackingStore extends VSocket | VSettings,
	RawWriteType extends KeywordPayload,
	UserWriteType,
	ParentType extends StronglyTypedSubtree<BackingStore>,
> implements IWritableKeyword<UserWriteType>
{
	readonly parent: ParentType;
	protected readonly m_kw: SysName;
	protected readonly m_write_converters: TypeConverters<
		BackingStore,
		RawWriteType,
		UserWriteType
	>;
	protected readonly m_anchored_write_validator: null | AnchoredWriteValidator<
		ParentType,
		UserWriteType
	>;
	constructor(
		parent: ParentType,
		m_kw: SysName,
		m_write_converters: TypeConverters<
			BackingStore,
			RawWriteType,
			UserWriteType
		>,
		badly_typed_validator: any,
	);
	write(
		payload: UserWriteType,
		opts?: WriteOptions<UserWriteType>,
	): Promise<void>;
}
export declare class wKeywordReferenceable<
	BackingStore extends VSocket | VSettings,
	member_name extends string,
	ScalarRawWriteType extends KeywordPayload,
	ScalarUserWriteType,
	RawWriteType extends KeywordPayload,
	UserWriteType,
	ParentLongType extends string,
	ParentType extends Referenceable<ParentLongType> &
		StronglyTypedSubtree<BackingStore>,
> extends wKeyword<BackingStore, RawWriteType, UserWriteType, ParentType> {
	private readonly m_scalar_converters;
	constructor(
		parent: ParentType,
		m_kw: SysName,
		m_scalar_converters: TypeConverters<
			BackingStore,
			ScalarRawWriteType,
			ScalarUserWriteType
		>,
		m_write_converters: TypeConverters<
			BackingStore,
			RawWriteType,
			UserWriteType
		>,
		badly_typed_write_validator: any,
	);
	reference_to_index(
		index: number,
	): RefinedIndexedNonmutatingReference<
		BackingStore,
		member_name,
		ParentLongType,
		ParentType,
		ScalarRawWriteType,
		ScalarUserWriteType
	>;
}
export declare class rwiKeyword<
		BackingStore extends VSocket | VSettings,
		ScalarRawType extends KeywordPayload,
		ScalarUserType,
		ParentType extends StronglyTypedSubtree<BackingStore>,
	>
	extends riKeyword<BackingStore, ScalarRawType, ScalarUserType, ParentType>
	implements IWritableKeyword<ScalarUserType>
{
	private m_lower;
	constructor(
		parent: ParentType,
		kw: SysName,
		index: number,
		type_converters: TypeConverters<
			BackingStore,
			ScalarRawType,
			ScalarUserType
		>,
	);
	write(
		payload: ScalarUserType,
		opts?: WriteOptions<ScalarUserType>,
	): Promise<void>;
}
export declare class rwKeyword<
		BackingStore extends VSocket | VSettings,
		RawReadType extends KeywordPayload,
		RawWriteType extends KeywordPayload,
		UserReadType,
		UserWriteType,
		ParentType extends StronglyTypedSubtree<BackingStore>,
	>
	extends rKeyword<BackingStore, RawReadType, UserReadType, ParentType>
	implements IWritableKeyword<UserWriteType>
{
	protected readonly m_write_converters: TypeConverters<
		BackingStore,
		RawWriteType,
		UserWriteType
	>;
	protected readonly m_anchored_write_validator: null | AnchoredWriteValidator<
		ParentType,
		UserWriteType
	>;
	constructor(
		parent: ParentType,
		m_kw: SysName,
		read_converters: TypeConverters<BackingStore, RawReadType, UserReadType>,
		m_write_converters: TypeConverters<
			BackingStore,
			RawWriteType,
			UserWriteType
		>,
		badly_typed_write_validator: any,
	);
	write(
		payload: UserWriteType,
		opts?: WriteOptions<UserWriteType>,
	): Promise<void>;
}
export declare class rwKeywordReferenceable<
	BackingStore extends VSocket | VSettings,
	member_name extends string,
	ScalarRawReadType extends KeywordPayload,
	ScalarRawWriteType extends KeywordPayload,
	ScalarUserReadType,
	ScalarUserWriteType,
	RawReadType extends ScalarRawReadType[],
	RawWriteType extends KeywordPayload,
	UserReadType extends ScalarUserReadType[],
	UserWriteType,
	ParentLongType extends string,
	ParentType extends Referenceable<ParentLongType> &
		StronglyTypedSubtree<BackingStore>,
> extends rwKeyword<
	BackingStore,
	RawReadType,
	RawWriteType,
	UserReadType,
	UserWriteType,
	ParentType
> {
	private readonly m_scalar_read_converters;
	private readonly m_scalar_write_converters;
	constructor(
		parent: ParentType,
		m_kw: SysName,
		m_scalar_read_converters: TypeConverters<
			BackingStore,
			ScalarRawReadType,
			ScalarUserReadType
		>,
		m_scalar_write_converters: TypeConverters<
			BackingStore,
			ScalarRawWriteType,
			ScalarUserWriteType
		>,
		read_converters: TypeConverters<BackingStore, RawReadType, UserReadType>,
		write_converters: TypeConverters<BackingStore, RawWriteType, UserWriteType>,
		badly_typed_write_validator: any,
	);
	reference_to_index(
		index: number,
	): RefinedIndexedNonmutatingReference<
		BackingStore,
		member_name,
		ParentLongType,
		ParentType,
		ScalarRawReadType,
		ScalarUserReadType
	>;
}
export declare class dKeyword<
	BackingStore extends VSocket | VSettings,
	RawReadType extends RawWriteType,
	RawWriteType extends KeywordPayload,
	UserReadType,
	UserWriteType,
	ParentType extends StronglyTypedSubtree<BackingStore>,
> {
	readonly status: rKeyword<
		BackingStore,
		RawReadType,
		UserReadType,
		ParentType
	>;
	readonly command: rwKeyword<
		BackingStore,
		RawReadType,
		RawWriteType,
		UserReadType,
		UserWriteType,
		ParentType
	>;
	constructor(
		parent: ParentType,
		kw: SysName,
		read_converters: TypeConverters<BackingStore, RawReadType, UserReadType>,
		write_converters: TypeConverters<BackingStore, RawWriteType, UserWriteType>,
		badly_typed_write_validator: any,
	);
	get parent(): ParentType;
}
export declare class dKeywordReferenceable<
	BackingStore extends VSocket | VSettings,
	member_name extends string,
	ScalarRawReadType extends RawWriteType,
	ScalarRawWriteType extends KeywordPayload,
	ScalarUserReadType,
	ScalarUserWriteType,
	RawReadType extends ScalarRawReadType[],
	RawWriteType extends KeywordPayload,
	UserReadType extends ScalarUserReadType[],
	UserWriteType,
	ParentLongType extends string,
	ParentType extends Referenceable<ParentLongType> &
		StronglyTypedSubtree<BackingStore>,
> {
	private readonly m_scalar_read_converters;
	private readonly m_scalar_write_converters;
	readonly status: rKeywordReferenceable<
		BackingStore,
		member_name,
		ScalarRawReadType,
		ScalarUserReadType,
		RawReadType,
		UserReadType,
		ParentLongType,
		ParentType
	>;
	readonly command: rwKeyword<
		BackingStore,
		RawReadType,
		RawWriteType,
		UserReadType,
		UserWriteType,
		ParentType
	>;
	constructor(
		parent: ParentType,
		kw: SysName,
		m_scalar_read_converters: TypeConverters<
			BackingStore,
			ScalarRawReadType,
			ScalarUserReadType
		>,
		m_scalar_write_converters: TypeConverters<
			BackingStore,
			ScalarRawWriteType,
			ScalarUserWriteType
		>,
		read_converters: TypeConverters<BackingStore, RawReadType, UserReadType>,
		write_converters: TypeConverters<BackingStore, RawWriteType, UserWriteType>,
		badly_typed_write_validator: any,
	);
	get parent(): ParentType;
}
export interface INamedTableRow {
	readonly index: number;
	rename(desired_name: string, opts?: CommonWriteOptions): Promise<void>;
	row_name(opts?: CommonCommandOptions): Promise<string>;
	delete(opts?: CommonWriteOptions): Promise<void>;
}
export declare class StronglyTypedNamedTable<
	BackingStore extends VSocket | VSettings,
	LongType extends string,
	S extends Referenceable<LongType> &
		INamedTableRow &
		StronglyTypedSubtree<BackingStore>,
> {
	readonly raw: SubtreeNamedTable<BackingStore>;
	private readonly m_lift;
	constructor(
		raw: SubtreeNamedTable<BackingStore>,
		m_lift: (
			raw: SubtreeNamedTableRow<BackingStore>,
			backing_store: BackingStore,
		) => S,
	);
	allocated_indices(opts?: CommonCommandOptions): Promise<number[]>;
	capacity(): number;
	is_allocated(index: number, opts?: CommonCommandOptions): Promise<boolean>;
	create_row(
		opts?: CommonWriteOptions & {
			index?: number;
			name?: string;
			allow_reuse_row?: boolean;
		},
	): Promise<S>;
	rows(opts?: CommonCommandOptions): Promise<S[]>;
	delete_all(): Promise<void>;
	ensure_allocated(n: number, mode: "exactly" | "atleast"): Promise<S[]>;
	row(index: number, opts?: CommonCommandOptions): S;
	row_unchecked(index: number): S;
}
export declare class StronglyTypedTable<
	BackingStore extends VSocket | VSettings,
	LongType extends string,
	S extends Referenceable<LongType> & StronglyTypedSubtree<BackingStore>,
> {
	readonly raw: SubtreeTable<BackingStore>;
	private readonly m_lift;
	constructor(
		raw: SubtreeTable<BackingStore>,
		m_lift: SubtreeLift<BackingStore, S>,
	);
	rows(opts?: CommonCommandOptions): Promise<S[]>;
	allocated_indices(opts?: CommonCommandOptions): Promise<number[]>;
	is_allocated(index: number, opts?: CommonCommandOptions): Promise<boolean>;
	row(index: number): S;
	[Symbol.asyncIterator](): AsyncGenerator<
		never,
		Generator<S, void, unknown>,
		unknown
	>;
}
export declare class StronglyTypedArray<
	BackingStore extends VSocket | VSettings,
	LongType extends string,
	S extends Referenceable<LongType> & StronglyTypedSubtree<BackingStore>,
> {
	private readonly raw;
	private readonly m_lift;
	constructor(
		raw: SubtreeArray<BackingStore>,
		m_lift: SubtreeLift<BackingStore, S>,
	);
	row(index: number): S;
	get size(): number;
	[Symbol.iterator](): Iterator<S>;
}
export declare class RefinedMutatingReference<
	BackingStore extends VSocket | VSettings,
	__ extends string,
	LongType extends string,
	ParentType extends Referenceable<LongType> &
		StronglyTypedSubtree<BackingStore>,
	ScalarRawType extends KeywordPayload,
	ScalarUserType,
> extends rwKeyword<
	BackingStore,
	ScalarRawType,
	ScalarRawType,
	ScalarUserType,
	ScalarUserType,
	ParentType
> {
	readonly enclosing_subtree: ParentType;
	constructor(
		enclosing_subtree: ParentType,
		kw: SysName,
		type_converters: TypeConverters<
			BackingStore,
			ScalarRawType,
			ScalarUserType
		>,
	);
	kw(): string;
}
export declare class RefinedNonmutatingReference<
	BackingStore extends VSocket | VSettings,
	__ extends string,
	LongType extends string,
	ParentType extends Referenceable<LongType> &
		StronglyTypedSubtree<BackingStore>,
	ScalarRawType extends KeywordPayload,
	ScalarUserType,
> extends rKeyword<BackingStore, ScalarRawType, ScalarUserType, ParentType> {
	readonly enclosing_subtree: ParentType;
	constructor(
		enclosing_subtree: ParentType,
		kw: SysName,
		type_converters: TypeConverters<
			BackingStore,
			ScalarRawType,
			ScalarUserType
		>,
	);
	kw(): string;
}
export declare class RefinedIndexedMutatingReference<
	BackingStore extends VSocket | VSettings,
	__ extends string,
	LongType extends string,
	ParentType extends Referenceable<LongType> &
		StronglyTypedSubtree<BackingStore>,
	ScalarRawType extends KeywordPayload,
	ScalarUserType,
> extends rwiKeyword<BackingStore, ScalarRawType, ScalarUserType, ParentType> {
	readonly enclosing_subtree: ParentType;
	constructor(
		enclosing_subtree: ParentType,
		kw: SysName,
		index: number,
		type_converters: TypeConverters<
			BackingStore,
			ScalarRawType,
			ScalarUserType
		>,
	);
	kw(): string;
}
export declare class RefinedIndexedNonmutatingReference<
	BackingStore extends VSocket | VSettings,
	__ extends string,
	LongType extends string,
	ParentType extends Referenceable<LongType> &
		StronglyTypedSubtree<BackingStore>,
	ScalarRawType extends KeywordPayload,
	ScalarUserType,
> extends riKeyword<BackingStore, ScalarRawType, ScalarUserType, ParentType> {
	readonly enclosing_subtree: ParentType;
	constructor(
		enclosing_subtree: ParentType,
		kw: SysName,
		index: number,
		type_converters: TypeConverters<
			BackingStore,
			ScalarRawType,
			ScalarUserType
		>,
	);
	kw(): string;
}
export {};
