import { VSettings, VSocket } from "./data_views.js";
import { reset_subtree_to_defaults } from "./schema_reflection.js";
import { Timestamp } from "./time.js";
import { asyncIter, enforce, enforce_nonnull } from "./utilities.js";
export async function reset_to_defaults(x) {
	await reset_subtree_to_defaults(
		x.raw.backing_store,
		x.raw.kwl,
		x.raw.description,
	);
}
export function same(a, b) {
	return null !== a && null !== b
		? a.raw.kwl === b.raw.kwl &&
				(a.raw.backing_store instanceof VSocket &&
				b.raw.backing_store instanceof VSocket
					? a.raw.backing_store.ip === b.raw.backing_store.ip
					: a.raw.backing_store instanceof VSettings &&
						b.raw.backing_store instanceof VSettings &&
						a.raw.backing_store === b.raw.backing_store)
		: (null === a) == (null === b);
}
export function nullableLiftOrLower(liftOrLower) {
	return (payload, backing_store) =>
		null === payload ? null : liftOrLower(payload, backing_store);
}
export class rKeyword {
	parent;
	m_kw;
	m_read_converters;
	constructor(parent, m_kw, m_read_converters) {
		(this.parent = parent),
			(this.m_kw = m_kw),
			(this.m_read_converters = m_read_converters);
	}
	async read(opts) {
		return this.m_read_converters.lift(
			await this.parent.raw.read({ kw: this.m_kw }, opts),
			this.parent.raw.backing_store,
		);
	}
	async wait_until(criterion, opts) {
		const f = this.m_read_converters
				? (payload) =>
						criterion(
							this.m_read_converters.lift(
								payload,
								this.parent.raw.backing_store,
							),
						)
				: criterion,
			result = await this.parent.raw.wait_until({ kw: this.m_kw }, f, opts);
		return this.m_read_converters.lift(result, this.parent.raw.backing_store);
	}
	async watch(handler, opts) {
		const f = this.m_read_converters
			? (payload) =>
					handler(
						this.m_read_converters.lift(payload, this.parent.raw.backing_store),
					)
			: handler;
		return await this.parent.raw.watch({ kw: this.m_kw }, f, opts);
	}
}
export class rKeywordReferenceable extends rKeyword {
	m_scalar_read_converters;
	constructor(parent, m_kw, m_scalar_read_converters, m_read_converters) {
		super(parent, m_kw, m_read_converters),
			(this.m_scalar_read_converters = m_scalar_read_converters);
	}
	reference_to_index(index) {
		return new RefinedIndexedNonmutatingReference(
			this.parent,
			this.m_kw,
			index,
			this.m_scalar_read_converters,
		);
	}
}
async function do_write(kw, payload, parent, type_converters, opts) {
	let lifted_validator;
	if (type_converters && "status" === opts?.retry_until?.criterion) {
		const v = opts.retry_until.validator;
		lifted_validator = (status) =>
			v(type_converters.lift(status, parent.raw.backing_store));
	}
	void 0 === lifted_validator &&
		payload instanceof Timestamp &&
		(lifted_validator = (status) =>
			(null === status && null === payload) ||
			payload.equal(type_converters.lift(status, parent.raw.backing_store))),
		await parent.raw.write(
			{ kw: kw },
			type_converters
				? type_converters.lower(payload, parent.raw.backing_store)
				: payload,
			{
				...opts,
				...(lifted_validator
					? {
							retry_until: { criterion: "status", validator: lifted_validator },
						}
					: {}),
			},
		);
}
export class riKeyword {
	parent;
	m_kw;
	index;
	m_lift;
	extract(payload, backing_store) {
		return null === payload ||
			payload.length <= this.index ||
			null === payload[this.index]
			? null
			: this.m_lift(payload[this.index], backing_store);
	}
	constructor(parent, m_kw, index, read_converters) {
		(this.parent = parent),
			(this.m_kw = m_kw),
			(this.index = index),
			(this.m_lift = (payload, backing_store) =>
				null === payload ? null : read_converters.lift(payload, backing_store));
	}
	async read(opts) {
		const raw = await this.parent.raw.read({ kw: this.m_kw }, opts);
		return null === raw || raw.length <= this.index
			? null
			: this.m_lift(raw[this.index], this.parent.raw.backing_store);
	}
	async wait_until(criterion, opts) {
		const raw_result = await this.parent.raw.wait_until(
			{ kw: this.m_kw },
			(payload) =>
				criterion(this.extract(payload, this.parent.raw.backing_store)),
			opts,
		);
		return this.extract(raw_result, this.parent.raw.backing_store);
	}
	async watch(handler, opts) {
		return await this.parent.raw.watch(
			{ kw: this.m_kw },
			(payload) => {
				handler(this.extract(payload, this.parent.raw.backing_store));
			},
			opts,
		);
	}
}
export class wKeyword {
	parent;
	m_kw;
	m_write_converters;
	m_anchored_write_validator;
	constructor(parent, m_kw, m_write_converters, badly_typed_validator) {
		(this.parent = parent),
			(this.m_kw = m_kw),
			(this.m_write_converters = m_write_converters),
			(this.m_anchored_write_validator = badly_typed_validator);
	}
	async write(payload, opts) {
		return do_write(this.m_kw, payload, this.parent, this.m_write_converters, {
			retry_until: { criterion: "custom", validator: async () => !0 },
			...(null === this.m_anchored_write_validator
				? {}
				: {
						retry_until: this.m_anchored_write_validator(this.parent, payload),
					}),
			...opts,
		});
	}
}
export class wKeywordReferenceable extends wKeyword {
	m_scalar_converters;
	constructor(
		parent,
		m_kw,
		m_scalar_converters,
		m_write_converters,
		badly_typed_write_validator,
	) {
		super(parent, m_kw, m_write_converters, badly_typed_write_validator),
			(this.m_scalar_converters = m_scalar_converters);
	}
	reference_to_index(index) {
		return new RefinedIndexedNonmutatingReference(
			this.parent,
			this.m_kw,
			index,
			this.m_scalar_converters,
		);
	}
}
export class rwiKeyword extends riKeyword {
	m_lower;
	constructor(parent, kw, index, type_converters) {
		super(parent, kw, index, type_converters),
			(this.m_lower = (payload, backing_store) =>
				null === payload
					? null
					: type_converters.lower(payload, backing_store));
	}
	async write(payload, opts) {
		await (async function (
			kw,
			payload,
			parent,
			non_nullable_type_converters,
			opts,
		) {
			const indices = Object.keys(payload).map((s) => parseInt(s));
			let lifted_validator;
			if ("status" === opts?.retry_until?.criterion) {
				const v = opts.retry_until.validator;
				lifted_validator = (status) => {
					if (null === status) return !1;
					for (const i of indices) {
						if (status.length <= i) return !1;
						if (
							v(
								non_nullable_type_converters.lift(
									status[i],
									parent.raw.backing_store,
								),
							)
						)
							return !1;
					}
					return !0;
				};
			}
			const converted_payload = {};
			for (const i of indices)
				converted_payload[i] = non_nullable_type_converters.lower(
					payload[i],
					parent.raw.backing_store,
				);
			await parent.raw.write({ kw: kw }, converted_payload, {
				...opts,
				...(lifted_validator
					? {
							retry_until: { criterion: "status", validator: lifted_validator },
						}
					: {}),
			});
		})(
			this.m_kw,
			{ [this.index]: payload },
			this.parent,
			{ lift: this.m_lift, lower: this.m_lower },
			opts,
		);
	}
}
export class rwKeyword extends rKeyword {
	m_write_converters;
	m_anchored_write_validator;
	constructor(
		parent,
		m_kw,
		read_converters,
		m_write_converters,
		badly_typed_write_validator,
	) {
		super(parent, m_kw, read_converters),
			(this.m_write_converters = m_write_converters),
			(this.m_anchored_write_validator = badly_typed_write_validator);
	}
	async write(payload, opts) {
		return do_write(this.m_kw, payload, this.parent, this.m_write_converters, {
			...(this.m_anchored_write_validator
				? { retry_until: this.m_anchored_write_validator(this.parent, payload) }
				: {}),
			...(opts ?? {}),
		});
	}
}
export class rwKeywordReferenceable extends rwKeyword {
	m_scalar_read_converters;
	m_scalar_write_converters;
	constructor(
		parent,
		m_kw,
		m_scalar_read_converters,
		m_scalar_write_converters,
		read_converters,
		write_converters,
		badly_typed_write_validator,
	) {
		super(
			parent,
			m_kw,
			read_converters,
			write_converters,
			badly_typed_write_validator,
		),
			(this.m_scalar_read_converters = m_scalar_read_converters),
			(this.m_scalar_write_converters = m_scalar_write_converters),
			this.m_scalar_write_converters;
	}
	reference_to_index(index) {
		return new RefinedIndexedNonmutatingReference(
			this.parent,
			this.m_kw,
			index,
			this.m_scalar_read_converters,
		);
	}
}
export class dKeyword {
	status;
	command;
	constructor(
		parent,
		kw,
		read_converters,
		write_converters,
		badly_typed_write_validator,
	) {
		(this.status = new rKeyword(parent, `${kw}_status`, read_converters)),
			(this.command = new rwKeyword(
				parent,
				`${kw}_command`,
				read_converters,
				write_converters,
				badly_typed_write_validator,
			));
	}
	get parent() {
		return this.status.parent;
	}
}
export class dKeywordReferenceable {
	m_scalar_read_converters;
	m_scalar_write_converters;
	status;
	command;
	constructor(
		parent,
		kw,
		m_scalar_read_converters,
		m_scalar_write_converters,
		read_converters,
		write_converters,
		badly_typed_write_validator,
	) {
		(this.m_scalar_read_converters = m_scalar_read_converters),
			(this.m_scalar_write_converters = m_scalar_write_converters),
			this.m_scalar_write_converters,
			(this.status = new rKeywordReferenceable(
				parent,
				`${kw}_status`,
				this.m_scalar_read_converters,
				read_converters,
			)),
			(this.command = new rwKeyword(
				parent,
				`${kw}_command`,
				read_converters,
				write_converters,
				badly_typed_write_validator,
			));
	}
	get parent() {
		return this.status.parent;
	}
}
export class StronglyTypedNamedTable {
	raw;
	m_lift;
	constructor(raw, m_lift) {
		(this.raw = raw), (this.m_lift = m_lift);
	}
	async allocated_indices(opts) {
		return this.raw.allocated_indices(opts);
	}
	capacity() {
		return this.raw.description.capacity;
	}
	async is_allocated(index, opts) {
		return this.raw.is_allocated(index, opts);
	}
	async create_row(opts) {
		return this.m_lift(await this.raw.create_row(opts), this.raw.backing_store);
	}
	async rows(opts) {
		return (await this.raw.rows(opts)).map((st) =>
			this.m_lift(st, this.raw.backing_store),
		);
	}
	async delete_all() {
		await this.raw.delete_all();
	}
	async ensure_allocated(n, mode) {
		let rows = await this.rows();
		return (
			rows.length < n
				? (await asyncIter(
						Array.from({ length: n - rows.length }, () => null),
						async () => {
							await this.create_row();
						},
					),
					(rows = await this.rows()))
				: rows.length > n &&
					"exactly" === mode &&
					(await asyncIter(rows.slice(n), async (row) => {
						await row.delete();
					}),
					(rows = rows.slice(0, n))),
			rows
		);
	}
	row(index, opts) {
		return this.m_lift(this.raw.row(index, opts), this.raw.backing_store);
	}
	row_unchecked(index) {
		return this.m_lift(this.raw.row_unchecked(index), this.raw.backing_store);
	}
}
export class StronglyTypedTable {
	raw;
	m_lift;
	constructor(raw, m_lift) {
		(this.raw = raw), (this.m_lift = m_lift);
	}
	async rows(opts) {
		return (await this.raw.rows(opts)).map((st) =>
			this.m_lift(st, this.raw.backing_store),
		);
	}
	async allocated_indices(opts) {
		return this.raw.allocated_indices(opts);
	}
	async is_allocated(index, opts) {
		return this.raw.is_allocated(index, opts);
	}
	row(index) {
		return this.m_lift(this.raw.row(index), this.raw.backing_store);
	}
	async *[Symbol.asyncIterator]() {
		const indices = await this.raw.allocated_indices(),
			self = this;
		return (function* () {
			for (const i of indices)
				yield self.m_lift(self.raw.row_unchecked(i), self.raw.backing_store);
		})();
	}
}
export class StronglyTypedArray {
	raw;
	m_lift;
	constructor(raw, m_lift) {
		(this.raw = raw), (this.m_lift = m_lift);
	}
	row(index) {
		return this.m_lift(this.raw.row(index), this.raw.backing_store);
	}
	get size() {
		return this.raw.description.capacity;
	}
	[Symbol.iterator]() {
		const N = this.size,
			self = this;
		return (function* () {
			for (let i = 0; i < N; ++i) yield self.row(i);
		})();
	}
}
export class RefinedMutatingReference extends rwKeyword {
	enclosing_subtree;
	constructor(enclosing_subtree, kw, type_converters) {
		super(enclosing_subtree, kw, type_converters, type_converters, null),
			(this.enclosing_subtree = enclosing_subtree);
	}
	kw() {
		return this.m_kw;
	}
}
export class RefinedNonmutatingReference extends rKeyword {
	enclosing_subtree;
	constructor(enclosing_subtree, kw, type_converters) {
		super(enclosing_subtree, kw, type_converters),
			(this.enclosing_subtree = enclosing_subtree);
	}
	kw() {
		return this.m_kw;
	}
}
export class RefinedIndexedMutatingReference extends rwiKeyword {
	enclosing_subtree;
	constructor(enclosing_subtree, kw, index, type_converters) {
		super(enclosing_subtree, kw, index, type_converters),
			(this.enclosing_subtree = enclosing_subtree);
	}
	kw() {
		return this.m_kw;
	}
}
export class RefinedIndexedNonmutatingReference extends riKeyword {
	enclosing_subtree;
	constructor(enclosing_subtree, kw, index, type_converters) {
		super(enclosing_subtree, kw, index, type_converters),
			(this.enclosing_subtree = enclosing_subtree);
	}
	kw() {
		return this.m_kw;
	}
}
