import { KeywordPayload, WriteValidator } from "./pervasives.js";
import { AtomicFieldDescription, KeywordDescription } from "./schema_v2.js";
export declare function atomic_equal(
	x: KeywordPayload,
	y: KeywordPayload,
	desc: AtomicFieldDescription<"annotated">,
): boolean;
export declare function status_is<T extends KeywordPayload>(
	x: T,
	maybe_desc: null | KeywordDescription<"annotated">,
): WriteValidator<T>;
export declare function status_sparsely_matches<T>(
	x: null | {
		[index: number]: T;
	},
): WriteValidator<null | T[]>;
export declare function max_abs_deviation(
	epsilon: number,
): (payload: number | null) => WriteValidator<number | null>;
export declare function max_rel_deviation(
	epsilon: number,
): (payload: number | null) => WriteValidator<number | null>;
