import { deepEqual } from "./polyfills/polyfill_util.js";
import { enforce, unreachable } from "./utilities.js";
import { Timestamp } from "./time.js";
export function atomic_equal(x, y, desc) {
	if (null === x && null === y) return !0;
	if (null !== x && null !== y)
		switch (desc.container_type) {
			case 0:
				switch (desc.data_type) {
					case "alerts":
					case "timecode":
						unreachable();
					case "atomic subtree":
						for (let i = 0; i < desc.children.length; ++i)
							if (!atomic_equal(x[i], y[i], desc.children[i])) return !1;
						return !0;
					case "variant":
						return (
							x[0] === y[0] && atomic_equal(x[1], y[1], desc.variants[x[0]][1])
						);
					case "bool":
					case "enum":
					case "ipaddress":
					case "ref":
					case "string":
						return x === y;
					case "device_tree_node":
						return deepEqual(x, y);
					case "float duration":
					case "float":
						return Math.abs(x - y) <= 1e-9;
					case "int":
					case "int duration":
						return x === y;
					case "timestamp":
						return new Timestamp(x).equal(new Timestamp(y));
				}
			case 2:
			case 3:
				if (x.length !== y.length) return !1;
				for (let i = 0; i < x.length; ++i)
					if (!atomic_equal(x[i], y[i], desc.contents)) return !1;
				return !0;
		}
	return !1;
}
function default_validator(x, maybe_desc) {
	return x && "object" == typeof x && !Array.isArray(x)
		? (y) => {
				if (null === y) return !1;
				for (const i in x) {
					const y_el = y[i],
						x_el = x[i];
					if (null !== maybe_desc) {
						if (!atomic_equal(y_el, x_el, maybe_desc.contents.contents))
							return !1;
					} else if (!deepEqual(y_el, x_el)) return !1;
				}
				return !0;
			}
		: maybe_desc
			? (y) => atomic_equal(x, y, maybe_desc.contents)
			: (y) => deepEqual(x, y);
}
export function status_is(x, maybe_desc) {
	return { criterion: "status", validator: default_validator(x, maybe_desc) };
}
export function status_sparsely_matches(x) {
	return {
		criterion: "status",
		validator: (y) => {
			if (null !== y && null !== x) {
				for (const i in x)
					if (parseInt(i, 10) >= y.length || !deepEqual(y[i], x[i])) return !1;
				return !0;
			}
			return (null === x) == (null === y);
		},
	};
}
export function max_abs_deviation(epsilon) {
	return (x) => ({
		criterion: "status",
		validator: (y) =>
			(null === y && null === x) ||
			(null !== y && null !== x && Math.abs(x - y) <= epsilon),
	});
}
export function max_rel_deviation(epsilon) {
	return (x) => ({
		criterion: "status",
		validator: (y) =>
			(null === y && null === x) ||
			(null !== y &&
				null !== x &&
				Math.abs(x - y) <= epsilon * Math.max(Math.abs(x), Math.abs(y))),
	});
}
