import { Duration } from "vscript";
import { Stats } from "./utils.js";
type Milliseconds = number;
type Label = string;
type Tag = string;
export declare class Benchmarks {
    private readonly mTags;
    private mData;
    constructor(mTags: Record<Tag, string | number>);
    benchmarked<T>(label: Label, promise: Promise<T>, pars?: {
        skip_if_below?: Duration;
    }): Promise<T>;
    empty(): boolean;
    to_influxdb_lineprotocol(pars: {
        measurement_name: string;
        precision: "ns" | "ms";
        tags?: Record<string, number | string | boolean>;
    }): string;
    to_string_hum(): string;
    to_json(): {
        tags: Record<string, string | number>;
        results: Record<string, {
            all_data: Milliseconds[];
            stats?: Stats<number> | undefined;
        }>;
    };
}
export {};
