export function ru32le(buf, offset) {
  return (
    buf[offset] + buf[offset + 1] * 2 ** 8 + buf[offset + 2] * 2 ** 16 + buf[offset + 3] * 2 ** 24
  );
}
export function ri32le(buf, offset) {
  return buf[offset] | (buf[offset + 1] << 8) | (buf[offset + 2] << 16) | (buf[offset + 3] << 24);
}
export function ru16be(buf, offset) {
  return (buf[offset] << 8) | buf[offset + 1];
}
export function ru24be(buf, offset) {
  return buf[offset] * 2 ** 16 + buf[offset + 1] * 2 ** 8 + buf[offset + 2];
}
export function ru32be(buf, offset) {
  return (
    buf[offset] * 2 ** 24 + buf[offset + 1] * 2 ** 16 + buf[offset + 2] * 2 ** 8 + buf[offset + 3]
  );
}
export function ri16be(buf, offset) {
  return ((buf[offset] << 24) | (buf[offset] << 16)) >> 16;
}
export function ri24be(buf, offset) {
  return ((buf[offset] << 24) | (buf[offset + 1] << 16) | (buf[offset + 2] << 8)) >> 8;
}
export function ri32be(buf, offset) {
  return (buf[offset] << 24) | (buf[offset + 1] << 16) | (buf[offset + 2] << 8) | buf[offset + 3];
}
export function ru8(buf, offset) {
  return buf[offset];
}
