/// <reference types="node" />
type BIW_HEADER = {
    Date: string;
    Time: string;
    SampleRate: number;
    BitDepth: number;
    SamplesPerChannles: number;
    Channels: number;
    Scale_Channels: number;
    MemTotal: number;
    Pages: number;
    Reader: number;
    AddrSize: number;
    Endianness: string;
};
declare class BUF_OBJ {
    shift: boolean;
    count: number;
    buf: Buffer;
    constructor(size: number);
}
export type DATA_TO_BIW = {
    header: BIW_HEADER;
    t_buffer: BUF_OBJ[];
};
export declare function encode_biw(data: DATA_TO_BIW): Buffer;
export declare function load_wave(source_file: string): Promise<DATA_TO_BIW>;
export declare function upload(url: string, data: Buffer): Promise<number>;
export declare function ll_to_wave(data: Buffer, channels: number): Buffer;
export {};
