export type DiffHunk = {
    removed: {
        start: number;
        end: number;
    };
    inserted: {
        start: number;
        end: number;
    };
};
export declare function parse_diff(diff_txt: string): DiffHunk[];
export declare function diff_files(pars: {
    left_filename: string;
    right_filename: string;
}): Promise<{
    diff_txt: string;
    diff_hunks: DiffHunk[];
}>;
export declare function diff(pars: {
    left: Array<string>;
    right: Array<string>;
}): Promise<{
    diff_txt: string;
    diff_hunks: DiffHunk[];
}>;
export interface MatchingRange {
    num_lines: number;
    line_start_left: number;
    line_start_right: number;
}
export declare function matching_ranges(diff_hunks: DiffHunk[], length_left: number, length_right: number): MatchingRange[];
