import { KWLName, KeywordPayload, SysName, VSocket, Watcher } from "vscript";
interface LivenessCanaryPayload {
    lastUpdate: Date | null;
    shouldCheck: () => Promise<boolean>;
    suspend: boolean;
    lastValue: KeywordPayload;
    watcher: Watcher;
    timeoutMS: number;
}
export declare class LivenessCanary {
    private payload;
    constructor(payload: LivenessCanaryPayload);
    watcher(): Watcher;
    disable(): void;
    enable(): void;
}
export declare class LivenessCanaries {
    readonly exit_on_error: boolean;
    private static TICK_INTERVAL_MS;
    private mTickTimer;
    private mLivenessState;
    constructor(exit_on_error: boolean);
    push(pars: {
        kwl: KWLName<"full">;
        kw: SysName;
        socket: VSocket;
        timeoutMS?: number;
        shouldCheck?: () => Promise<boolean>;
    }): Promise<LivenessCanary>;
    arm(): void;
    disarm(): void;
    armed(): boolean;
    remove(canary: LivenessCanary): void;
    clear(): void;
    iter(f: (pars: {
        kwl: KWLName<"full">;
        kw: SysName;
        socket: VSocket;
    }) => "suspend" | "enable" | "leave-unchanged"): void;
    private tick;
}
export {};
