import { isDeepStrictEqual as orig_equal } from "util";
import * as process from "process";
export function getenv(key, _typedesc) {
  return process.env[key];
}
export function env_keys(key) {
  const result = [];
  for (const key2 in process.env) {
    if (key.toLowerCase() === key2.toLowerCase()) result.push(key2);
  }
  if (result.length === 0) result.push(key);
  return result;
}
export function isDeepStrictEqual(a, b) {
  return orig_equal(a, b);
}
export async function with_suppressed_tls_checks(f) {
  const old = process.env["NODE_TLS_REJECT_UNAUTHORIZED"];
  process.env["NODE_TLS_REJECT_UNAUTHORIZED"] = "0";
  try {
    const res = await f();
    return res;
  } finally {
    process.env["NODE_TLS_REJECT_UNAUTHORIZED"] = old;
  }
}
