/// <reference types="node" />
/// <reference types="node" />
import { Readable } from "stream";
import { Logger } from "vscript";
import { Buffer } from "buffer";
export interface PCapHeader {
    magic_number: number;
    version_major: number;
    version_minor: number;
    thiszone: number;
    sigfigs: number;
    snaplen: number;
    network: number;
    endianness: "BE" | "LE";
}
export interface PacketHeader {
    ts_sec: number;
    ts_nsec: number;
    incl_len: number;
    orig_len: number;
}
interface PCapReaderPars {
    instream: Readable;
    preprocess?: string;
    "tcpdump-filter"?: string;
    "display-filter"?: string;
    log?: Logger;
}
export declare function iter_pcap(pars: PCapReaderPars): AsyncGenerator<{
    frame_number: number;
    ts_sec: number;
    ts_nsec: number;
    data: Buffer;
}>;
interface IPPacket {
    frame_number: number;
    ts_sec: number;
    ts_nsec: number;
    ip_src: number;
    ip_dst: number;
    proto: number;
    ip_payload: Buffer;
}
export declare function iter_pcap_ipv4(pars: PCapReaderPars): AsyncGenerator<IPPacket>;
export declare function iter_pcap_udp(pars: PCapReaderPars): AsyncGenerator<{
    frame_number: number;
    ts_sec: number;
    ts_nsec: number;
    ip_src: number;
    ip_dst: number;
    udp_src_port: number;
    udp_dst_port: number;
    udp_payload: Buffer;
}>;
interface RTPPacket {
    frame_number: number;
    ts_sec: number;
    ts_nsec: number;
    ip_src: number;
    ip_dst: number;
    udp_src_port: number;
    udp_dst_port: number;
    rtp_marker: boolean;
    rtp_pt: number;
    rtp_seq: number;
    rtp_timestamp: number;
    rtp_ssrc: number;
    rtp_payload: Buffer;
}
export declare function iter_pcap_rtp(pars: PCapReaderPars): AsyncGenerator<RTPPacket>;
export declare function iter_pcap_rtp_inorder(pars: PCapReaderPars & {
    max_reorder?: number;
    filter: (p: RTPPacket) => boolean;
}): AsyncGenerator<{
    missing: false;
    pkt: RTPPacket;
} | {
    missing: true;
    rtp_seq: number;
}>;
export declare function num_of_ipv4(addr: string): number;
export {};
