import * as VAPI from "vapi";
import { Duration, Logger } from "vscript";
import { RollbackStack } from "./rollback_stack.js";
export interface PTPPars {
    ptp_domain: number;
    mode: "SlaveOnly" | "FreerunMaster" | "GPSMaster";
    log: Logger;
    delay_resp_mode: "Unicast" | "Multicast";
    ttl: number;
    log2_delayreq_interval: number;
    log2_announce_interval: number;
    log2_sync_interval: number;
    await_calibration: boolean;
    locking_policy: "Locking" | "Dynamic";
}
export declare function setup_ptp(vm: VAPI.VM.Any, parameters?: Partial<PTPPars>): Promise<void>;
export declare function ensureAgent(vm: VAPI.VM.Any, pars: {
    domain: number;
    port?: VAPI.Any.PTPFlows.Port;
} & ({
    mode: "SlaveOnly";
} | {
    mode: "MasterSlave" | "MasterOnly";
    time_source: VAPI.AT1101.Time.Source | VAPI.AT1130.Time.Source;
})): Promise<VAPI.AT1101.PTPFlows.AgentAsNamedTableRow | VAPI.AT1130.PTPFlows.AgentAsNamedTableRow>;
export declare function stretch_clock_input(pars: {
    drift: number;
    blade: VAPI.VM.Any;
    rollback_stack?: RollbackStack;
    timeout?: Duration;
}): Promise<void>;
export declare function shift_clock_input(pars: {
    offset: Duration;
    blade: VAPI.VM.Any;
    rollback_stack?: RollbackStack;
    timeout?: Duration;
}): Promise<void>;
