import { enforce, enforce_nonnull } from "vscript";
export function random_number(min, max, pars) {
  enforce(min <= max);
  if ((pars?.prefer_boundaries ?? true) && Math.random() < 0.25) {
    if (min < 0 && max > 0 && Math.random() < 0.33) {
      return 0;
    }
    return Math.random() < 0.5 ? min : max;
  }
  return min + (max - min) * Math.random();
}
export function maybe_null(x) {
  if (Math.random() < 0.2) {
    return null;
  }
  return x;
}
export function random_int(min, max, pars) {
  enforce(Math.round(min) === min && Math.round(max) === max);
  return Math.round(random_number(min, max, pars));
}
export function random_choice(choices, pars) {
  if (choices.length === 0) {
    throw new Error("random_choice requires a nonempty list of choices");
  }
  return choices[random_int(0, choices.length - 1, pars)];
}
export function random_string(minLength, maxLength, pars) {
  let result = "";
  const L = enforce_nonnull(random_int(minLength, maxLength));
  for (let i = 0; i < L; ++i) {
    const n = random_int(pars?.permitNullBytes ?? true ? 1 : 0, 65535);
    if (n > 255) {
      result += String.fromCharCode(n >> 8, n & 0xff);
    } else {
      result += String.fromCharCode(n);
    }
  }
  return result;
}
export function log_rand(min, max) {
  enforce(min > 0 && max > 0);
  const ordersOfMagnitude = Math.log(max) - Math.log(min);
  return Math.min(max, Math.max(min, Math.exp(Math.log(min) + Math.random() * ordersOfMagnitude)));
}
export const random_subset = (choices, num_choices) => {
  const _choices = [...choices];
  const selections = [];
  for (let i = 0; i < num_choices; ++i) {
    const pos = random_int(0, _choices.length - 1);
    const selection = _choices.splice(pos, 1);
    selections.push(selection[0]);
    if (_choices.length <= 0) break;
  }
  return selections;
};
export function random_duration(min, max, pars) {
  return min.plus(max.minus(min).times(random_number(0, 1, pars)));
}
