import { enforce } from "vscript";
export class RollbackStack {
  mHandlers = [];
  mArmed = true;
  push(f) {
    enforce(this.mArmed);
    this.mHandlers.push(f);
  }
  async rollback() {
    if (!this.mArmed) return;
    this.mArmed = false;
    const msgs = [];
    for (const handler of this.mHandlers.reverse()) {
      try {
        await handler();
      } catch (e) {
        let msg = "Failure during rollback";
        if (typeof e.toString() === "function") {
          msg += `: ${e.toString()}`;
        }
        if (typeof e.stack === "string") {
          msg += e.stack;
        }
        msgs.push(msg);
      }
    }
    if (msgs.length !== 0)
      throw new Error(
        `${msgs.length} failure${msgs.length > 1 ? "s" : ""} during rollback: ${msgs.join(",\n")}`,
      );
  }
  async with_rollback_do(f, fInverse) {
    const result = await f();
    this.push(fInverse);
    return result;
  }
}
