/// <reference types="node" />
import { ExecException, ExecFileException } from "child_process";
import { Duration } from "vscript";
export declare function sh(command: string, opts?: {
    echo_command?: boolean;
    fail_on_error?: boolean;
    forward_io?: boolean;
    max_buffer_bytes?: number;
    timeout?: Duration;
}): Promise<{
    stdout: string;
    stderr: string;
    err: ExecException | null;
}>;
export declare function system(command: string, args: string[], opts?: {
    echo_command?: boolean;
    fail_on_error?: boolean;
    forward_io?: boolean;
    max_buffer_bytes?: number;
    timeout?: Duration;
}): Promise<{
    stdout: string;
    stderr: string;
    err: ExecFileException | null;
}>;
export declare function executable_path(executable_name: string): Promise<string | null>;
export declare function has_executable(executable_name: string): Promise<boolean>;
