export declare class RTPListener {
    private m_procs;
    constructor(pars: {
        streams: Array<{
            src_ip: string;
            dst_ip: string;
            dst_port: number;
        }>;
        ifc: string;
        fields: string[];
        callback: (response: Record<string, string>) => void;
        extra_tshark_args?: string[];
    });
    close(): void;
}
export interface MarkerResponse {
    time_relative: number;
    src_ip: string;
    dst_ip: string;
    dst_port: number;
    rtp_seqnr: number;
    rtp_marker: true;
}
export interface ST2110_40_NonMarker_Response {
    time_relative: number;
    src_ip: string;
    dst_ip: string;
    dst_port: number;
    rtp_seqnr: number;
    rtp_marker: false;
    did: number;
    sdid: number;
    line_number: number;
    udw_array: string;
    dc: number;
    time_code: null | {
        payload_type: number;
        as_string: string;
    };
    F: any;
}
export type ST2110_40_Response = MarkerResponse | ST2110_40_NonMarker_Response;
export declare class ST2110_40_Listener {
    private m_rtp_listener;
    constructor(pars: {
        streams: Array<{
            src_ip: string;
            dst_ip: string;
            dst_port: number;
        }>;
        ifc: string;
        rtp_payload: number;
        callback: (response: ST2110_40_Response) => void;
    });
    close(): void;
}
export declare class ST2110_40_Listeners {
    private m_listeners;
    constructor(pars: {
        streams: Array<{
            src_ip: string;
            dst_ip: string;
            dst_port: number;
            rtp_payload: number;
        }>;
        ifc: string;
        callback: (response: ST2110_40_Response) => void;
    });
    close(): void;
}
