import * as VAPI from "vapi";
import { Duration, IReadableKeyword, Logger, Referenceable, INamedTableRow, StronglyTypedNamedTable, StronglyTypedSubtree, Timestamp, VSocket, VSettings } from "vscript";
export declare function scrub(vm: VAPI.VM.Any, opts?: {
    log?: (msg: string) => void;
    reset_keywords?: boolean;
    kwl_whitelist?: RegExp[];
}): Promise<void>;
export declare function deduplicateCustom<T>(ts: T[], stringifier: (t: T) => string): T[];
export declare function deduplicate<T extends StronglyTypedSubtree<VSocket>>(ts: T[]): T[];
export interface Stats<T extends number> {
    min: T;
    q5: T;
    median: T;
    q95: T;
    max: T;
    mean: T;
    stddev: T;
}
export declare function stats<T extends number>(xs: T[]): Stats<T> | null;
export declare function histogram(pars: {
    data: Duration[] | number[];
    bincount: number;
}): Array<[x: Duration, y: number]> | Array<[x: number, y: number]>;
export declare function shorttime(d?: Date): string;
export declare function range(start: number, stopExclusive: number, step?: number): number[];
export declare function enumerate<T>(xs: Iterable<T>): Iterable<[i: number, x: T]>;
export declare function video_ref(essence: VAPI.AT1101.Video.Essence | VAPI.AT1130.Video.Essence | null, switch_time?: Timestamp): {
    source: any;
    switch_time: Timestamp | null;
};
export declare function audio_ref(essence: VAPI.AT1101.Audio.Essence | VAPI.AT1130.Audio.Essence | null, switch_time?: Timestamp): {
    source: any;
    switch_time: Timestamp | null;
};
export declare function time_ref(t_src: VAPI.AT1101.Time.Source | VAPI.AT1130.Time.Source): any;
type Accumulator<T, Acc> = (pars: {
    acc: undefined | Acc;
    value: T;
}) => Acc;
interface StreakParameters<T, Acc> {
    n: number;
    test: (x: {
        acc: Acc;
        prev: T;
        value: T;
    }) => boolean;
    timeout: Duration;
    poll_interval?: Duration;
}
export declare function streak<T, Acc = T>(kw: IReadableKeyword<T>, pars: StreakParameters<T, Acc>): Promise<T>;
export declare function streak<T, Acc>(kw: IReadableKeyword<T>, pars: StreakParameters<T, Acc>, maybe_accumulator: Accumulator<T, Acc>): Promise<Acc>;
export declare function wait_until_stable<T>(kw: IReadableKeyword<T>, pars: {
    maxJitter: number;
    log?: (raw_payload: T | null, consec_stable_samples: number) => void;
    min_consec_stable_samples?: number;
    timeout?: Duration;
    transformer?: (payload: T) => undefined | number;
}): Promise<T>;
export declare function constant<Payload = any, Transformed = Payload>(pars: {
    runLength: number;
    log?: Logger;
    transformer?: (payload: Payload) => Transformed;
}): (payload: Payload) => boolean;
export declare function fc_diff(fc_from: number, fc_to: number): number;
export declare function counts_to_duration(counts: number, vm: VAPI.VM.Any): Duration;
export declare class Variance {
    private dataset;
    private arraySize;
    private resultValid;
    private index;
    private variance;
    constructor(size_dataset?: number);
    push(val: number): void;
    mean(): number;
    value(): number;
    size(): number;
    valid(): boolean;
    calculate(): number;
}
export declare function all_pairs<T, S>(xs: T[], ys: S[]): Array<[T, S]>;
export declare function gather<T>(kw: IReadableKeyword<T>, pars: {
    min_count: number;
    update_interval?: Duration;
    timeout: Duration;
    equal: (a: T, b: T) => boolean;
    filter?: (x: T) => boolean;
}): Promise<Array<{
    value: T;
    count: number;
}>>;
export declare function pretty_join(things: string[]): string;
export declare function has_reconfigurable_ioboard(vm: VAPI.VM.Any): Promise<boolean>;
export declare function hosting_vm(st: StronglyTypedSubtree<VSocket>): VAPI.VM.Any;
export declare function delete_row(st: StronglyTypedSubtree<VSocket>): Promise<void>;
export type ResourceCount = {
    kind: "max";
} | {
    kind: "at-most" | "exactly";
    n: number;
};
export declare function find_vm_and_count(vms: VAPI.VM.Any[], maxcount: (vm: VAPI.VM.Any) => Promise<number>, required_count: ResourceCount, labels: {
    resource: string;
    specs: string;
}): Promise<[VAPI.VM.Any | null, number]>;
type RowTypeOf<Table> = Table extends StronglyTypedNamedTable<VSocket | VSettings, string, infer R> ? R : never;
export declare function find_by_rowname<Id extends string, RowType extends Referenceable<Id> & INamedTableRow & StronglyTypedSubtree<VSocket | VSettings>, Table extends StronglyTypedNamedTable<VSocket | VSettings, Id, RowType>>(r: Table, name: string): Promise<RowTypeOf<Table> | null>;
export declare function ensure_nmos_settings(vm: VAPI.VM.Any, params?: {
    registry?: URL;
    enable?: boolean;
    log?: Logger;
}): Promise<boolean>;
export {};
