import * as VAPI from "vapi";
import { Duration } from "vscript";
export interface StandardInfo {
    frameRate: VAPI.Video.FrameRate;
    height: 486 | 576 | 720 | 1080 | 2160;
    interlaced: boolean;
    restrict_to_transport_formats?: readonly VAPI.Video.TransportFormat[];
    segmented?: boolean;
    width: number;
    t_height: number;
    t_width: number;
}
export declare function frameRate(std: VAPI.Video.Standard): VAPI.Video.FrameRate;
export declare function exactFrameRate(std: VAPI.Video.Standard): number[];
export declare function vstart(std: VAPI.Video.Standard, field: "first" | "second" | null): 20 | 336 | 23 | 283 | 26 | 584 | 21 | 42;
export declare function vend(std: VAPI.Video.Standard, field: "first" | "second" | null): 1 | 624 | 311 | 264 | 746 | 1124 | 561 | 1122;
export declare function framelength(std: VAPI.Video.Standard): Duration;
export declare function modulo_framelength(d: Duration, std: VAPI.Video.Standard): Duration;
export declare function standard_info(std: VAPI.Video.Standard): StandardInfo;
export declare function is_3G(std: VAPI.Video.Standard): boolean;
export declare function is_3G_or_higher(std: VAPI.Video.Standard): boolean;
export declare function is_higher_than_3G(std: VAPI.Video.Standard): boolean;
export declare function is_12G(std: VAPI.Video.Standard): boolean;
export declare function get_audio_signal_generator(vm: VAPI.VM.Any): VAPI.AT1101.AudioSignalGenerator.All | VAPI.AT1130.AudioSignalGenerator.OUTS;
export declare function guess_standard(pars: {
    width: number;
    height: number;
}): VAPI.Video.Standard;
