import * as https from "https";
import { enforce } from "vscript";
import { Buffer } from "buffer";
export function runCmds(pars) {
  return new Promise((resolve, reject) => {
    let data = null;
    try {
      const req = https
        .request(
          {
            headers: {
              authorization:
                "Basic " + Buffer.from(`${pars.user}:${pars.password}`).toString("base64"),
            },
            host: pars.mgmtAddress,
            method: "POST",
            path: "/command-api",
            port: 443,
            rejectUnauthorized: false,
          },
          (rsp) => {
            rsp.setEncoding("utf8");
            rsp.on("data", (chunk) => {
              if (rsp.statusCode === 200) {
                if (data === null) {
                  data = chunk;
                } else if (typeof chunk === "string") {
                  enforce(typeof data === "string");
                  data += chunk;
                } else {
                  enforce(data instanceof Buffer);
                  enforce(chunk instanceof Buffer);
                  data = Buffer.concat([data, chunk]);
                }
              } else {
                reject(rsp);
              }
            });
            rsp.on("end", () => resolve(data instanceof Buffer ? data.toString() : data));
          },
        )
        .on("error", (e) => reject(e));
      req.write(
        JSON.stringify({
          id: "test",
          jsonrpc: "2.0",
          method: "runCmds",
          params: {
            cmds: pars.commands,
            format: "json",
            version: 1,
          },
        }),
      );
      req.end();
    } catch (e) {
      reject(e);
    }
  });
}
export async function configLink(pars) {
  await runCmds({
    commands: [
      "enable",
      "configure",
      `interface ${pars.linkInfo.ifcName.replace(/Ethernet(.*)/, "Et $1")}`,
      ...pars.cmds,
    ],
    mgmtAddress: pars.linkInfo.mgmtAddress,
    password: pars.password,
    user: pars.user,
  });
}
export async function configSwitch(pars) {
  await runCmds({
    commands: ["enable", "configure", ...pars.cmds],
    mgmtAddress: pars.linkInfo.mgmtAddress,
    password: pars.password,
    user: pars.user,
  });
}
export async function setLink(pars) {
  await configLink({
    cmds: [pars.mode],
    linkInfo: pars.linkInfo,
    password: pars.password,
    user: pars.user,
  });
}
