import * as VAPI from "vapi";
import { Audio, Definitions } from "vapi";
export type SampleCount = 6 | 12 | 16 | 24 | 32 | 48;
export declare const PTIME_MAP: Record<SampleCount, Definitions.PacketTime>;
export declare const REVERSE_PTIME_MAP: Record<Definitions.PacketTime, SampleCount>;
export declare function bytes_per_sample(format: Audio.Format): 2 | 4 | 3;
export declare function max_num_channels(pars: {
    audio_format: Audio.Format;
    samplecount: SampleCount;
}): number;
export declare function allowed_channelcounts(tx: VAPI.Any.RTPTransmitter.AudioStreamer, pars: {
    ptime: Definitions.PacketTime;
    audio_format: Audio.Format;
}): number[];
export declare function get_peaks(a: VAPI.Any.Audio.Essence): Promise<(number | undefined)[]>;
export declare function asg_level_to_peak(level: VAPI.Audio.Level): number;
export declare function make_expected_peak_levels(pars: {
    level: number;
    channels?: number;
    used_channels?: number;
}): (number | undefined)[];
