import * as VAPI from "vapi";
export const PTIME_MAP = {
  6: "p0_125",
  12: "p0_250",
  16: "p0_333",
  24: "p0_500",
  32: "p0_666",
  48: "p1",
};
export const REVERSE_PTIME_MAP = {
  p0_125: 6,
  p0_250: 12,
  p0_333: 16,
  p0_500: 24,
  p0_666: 32,
  p1: 48,
};
export function bytes_per_sample(format) {
  switch (format) {
    case "L16":
      return 2;
    case "L24":
      return 3;
    case "AM824":
      return 4;
  }
}
export function max_num_channels(pars) {
  if (PTIME_MAP[pars.samplecount] === undefined) {
    return 0;
  }
  const MAX_PAYLOAD_BYTES = 1440;
  return Math.min(
    80,
    Math.floor(MAX_PAYLOAD_BYTES / (bytes_per_sample(pars.audio_format) * pars.samplecount)),
  );
}
export function allowed_channelcounts(tx, pars) {
  const result = [];
  const samplecount = REVERSE_PTIME_MAP[pars.ptime];
  for (
    let channels = 1;
    channels <= max_num_channels({ audio_format: pars.audio_format, samplecount });
    ++channels
  ) {
    if (pars.audio_format === "L24" && tx instanceof VAPI.AT1130.RTPTransmitter.AudioStreamer) {
      const magic_remainder = (8 + channels * samplecount * 3) % 32;
      if (magic_remainder === 1 || magic_remainder === 2) continue;
    }
    result.push(channels);
  }
  return result;
}
export async function get_peaks(a) {
  const channels = await a.channels.read();
  const slice_peaks = new Map();
  await Promise.all(
    channels.map(async (c) => {
      const ass = c?.signal?.enclosing_subtree;
      if (ass) {
        const name = ass.raw.kwl;
        if (!slice_peaks.has(name)) {
          slice_peaks.set(name, []);
          const peaks = await ass.peak_meter.read();
          slice_peaks.set(name, peaks);
        }
      }
    }),
  );
  return channels.map((c) => {
    const ass = c?.signal?.enclosing_subtree;
    return ass ? slice_peaks.get(ass.raw.kwl)?.[c.signal.index] : undefined;
  });
}
export function asg_level_to_peak(level) {
  switch (level) {
    case "set_6dbfs":
      return -60;
    case "set_18dbfs":
      return -180;
    case "set_20dbfs":
      return -200;
  }
}
export function make_expected_peak_levels(pars) {
  const channels = pars.channels ?? 80;
  const used_channels = pars.used_channels ?? 80;
  if (channels > used_channels)
    throw new Error(`channels ${channels} must not bigger than used_channels ${used_channels}`);
  return [...Array(80)].map((_, i) => {
    return i < channels ? pars.level : i < used_channels ? -32768 : undefined;
  });
}
