/// <reference types="node" />
/// <reference types="node" />
import { Svg } from "@svgdotjs/svg.js";
import { BinaryToTextEncoding } from "crypto";
import { default as Jimp } from "jimp";
import * as VAPI from "vapi";
import { ST291Packet } from "./metadata.js";
export type Sampling = "422" | "444";
export type YCbCr = {
    type: "YCbCr";
    width: number;
    height: number;
    sampling: Sampling;
    y: Int16Array;
    cb: Int16Array;
    cr: Int16Array;
};
export type MinMax = {
    min: number;
    max: number;
};
export type MinMaxYCbCr = {
    y: MinMax;
    cb: MinMax;
    cr: MinMax;
};
export type OffsetScale = {
    offset?: number;
    scale?: number;
};
export type OffsetScaleYCbCr = {
    y: OffsetScale;
    cb: OffsetScale;
    cr: OffsetScale;
};
export type BIDHeader = {
    Date: string;
    Time: string;
    Hostname: string;
    Blanking: boolean;
    Interlace: boolean;
    HTotal: number;
    VTotal: number;
    HActive: number;
    VActive: number;
    Frames: number;
    Standard: VAPI.Video.Standard;
};
export declare class BIDFrame {
    readonly pixels: YCbCr;
    readonly meta?: ST291Packet[][];
    constructor(pars: {
        width: number;
        height: number;
        sampling: "422" | "444";
        meta?: ST291Packet[][];
    });
    to_ascii(): string;
    to_hash(algorithm: string, encoding?: BinaryToTextEncoding): string;
    static from_image(image: Jimp, opts?: {
        colorspace?: VAPI.Video.ColorSpace;
    }): BIDFrame;
    to_image(opts?: {
        timecode?: "burn-in";
        font?: string;
        colorspace?: VAPI.Video.ColorSpace;
    }): Promise<Jimp>;
    to_yuv(fmt: "YUV" | "YUV10"): Buffer;
    mse(other: BIDFrame): number;
    diff(other: BIDFrame): BIDFrame;
    minmax(): MinMaxYCbCr;
    apply(par: OffsetScaleYCbCr): BIDFrame;
    subarea(hoff: number, voff: number, width: number, height: number): BIDFrame;
}
export type FrameRenderer = (pars: {
    frame_index: number;
    num_frames: number;
    svg: Svg;
    width: number;
    height: number;
}) => Promise<void>;
export declare function extract_header(path: string): Promise<Buffer>;
export declare function parse_header(path: string): Promise<BIDHeader>;
export declare function concat_bids_on_disk(pars: {
    output_filename: string;
    infiles: string[];
}): Promise<void>;
export declare class BID {
    readonly buffer: Buffer;
    readonly hdr: BIDHeader;
    private readonly hdr_end;
    constructor(buffer: Buffer);
    raw_data(): Buffer;
    bid_geometry(): {
        width: number;
        height: number;
        lineLen: number;
        lineStride: number;
        frameStride: number;
        eavSkip: number;
    };
    frame(framenumber: number, opts?: {
        strip_blanking?: boolean;
    }): BIDFrame;
    frames(opts?: {
        strip_blanking?: boolean;
    }): Generator<BIDFrame>;
    concat(other: BID): BID;
    static from_frame(frame: BIDFrame, opts?: {
        standard?: VAPI.Video.Standard;
        date?: Date;
    }): BID;
    static from_images(images: Jimp[], opts?: {
        standard?: VAPI.Video.Standard;
        colorspace?: VAPI.Video.ColorSpace;
        context?: {
            aborted: boolean;
            info?: (msg: string) => void;
        };
    }): {
        fill: BID;
        alpha: BID;
    };
    static download_from(delay: VAPI.Any.VideoRePlay.Delay, opts?: {
        frame_index?: number;
    }): Promise<BID>;
    upload_to(player: VAPI.Any.VideoPlayer.Player): Promise<void>;
    static from_inkscape(pars: {
        svg_filenames: string[];
        standard?: VAPI.Video.Standard;
        context?: {
            aborted: boolean;
            info?: (msg: string) => void;
        };
        tmp_dir?: string;
    }): Promise<{
        fill: BID;
        alpha: BID;
    }>;
    static draw_with_inkscape(pars: {
        standard: VAPI.Video.Standard;
        num_frames: number;
        f: FrameRenderer;
        extract_alpha: boolean;
    }): Promise<{
        fill: BID;
        alpha: BID;
    }>;
}
export declare function round_clamp(v: number, min: number, max: number): number;
type Matrix_3x3 = [number, number, number, number, number, number, number, number, number];
export declare function invert_3x3(matrix: Matrix_3x3): Matrix_3x3;
export declare function conversion_matrix(cs: VAPI.Video.ColorSpace): Matrix_3x3;
export declare class UnpackedBID {
    readonly hdr: BIDHeader;
    readonly frames: Uint16Array[];
    readonly height: number;
    readonly frameStride: number;
    readonly lineLen: number;
    readonly lineStride: number;
    readonly samplesPerLine: number;
    private constructor();
    static from_bid(bid: BID): UnpackedBID;
    private enforce_blanking;
    scrub_blanking(): void;
    sabotage_edh(): void;
    regenerate_edh(): void;
    to_bid(): BID;
}
export {};
