import * as VAPI from "vapi";
import { Timestamp, VSocket } from "vscript";
export class ClockTracker {
  anchor = [new Timestamp(0), 0];
  watcher;
  constructor() {}
  async initialize(vsocket) {
    if (vsocket.build_info.version.startsWith("1.")) {
      this.anchor = [
        new Timestamp((await vsocket.read({ kwl: "p_t_p_clock.micro_epochs", kw: "current" }))[2]),
        new Date().valueOf(),
      ];
      this.watcher = await vsocket.watch(
        { kwl: "p_t_p_clock.micro_epochs", kw: "current" },
        (x) => (this.anchor = [new Timestamp(x[2]), new Date().valueOf()]),
      );
    } else {
      const vm = VAPI.VM.adopt(vsocket);
      this.anchor = [
        (await vm.p_t_p_clock.micro_epochs.read()).current.reference_time,
        new Date().valueOf(),
      ];
      this.watcher = await vm.p_t_p_clock.micro_epochs.watch((epochs) => {
        this.anchor = [epochs.current.reference_time, new Date().valueOf()];
      });
    }
  }
  close() {
    this.watcher?.unwatch();
    this.watcher = undefined;
  }
  to_ptp(date) {
    const delta = date.valueOf() - this.anchor[1];
    const t = Math.round(this.anchor[0].seconds() * 1e3 + delta) * 1e-3;
    return t;
  }
  now_ptp() {
    return this.to_ptp(new Date());
  }
  static async create(vm_or_socket) {
    const tracker = new ClockTracker();
    await tracker.initialize(vm_or_socket instanceof VSocket ? vm_or_socket : vm_or_socket.raw);
    return tracker;
  }
}
