import { VM } from "vapi";
import { Duration, MachineAddress } from "vscript";
export declare class ParseFailure {
}
type Parser<T> = (env_val: string | undefined, machines: VM.Any[]) => Promise<T>;
type Parspec<T> = {
    parser: Parser<T>;
    description: () => string;
};
type ParameterDefault<T> = T | ((machines: VM.Any[]) => T) | ((machines: VM.Any[]) => Promise<T>);
declare function make_bool_parspec(default_value?: ParameterDefault<boolean>): Parspec<boolean>;
declare function make_string_parspec(default_value?: ParameterDefault<string>): Parspec<string>;
declare function make_enum_parspec<T extends string>(enumerators: T[], default_value?: ParameterDefault<T>): Parspec<T>;
declare function make_list_parspec<T>(element_parspec: Parspec<T>, default_value?: ParameterDefault<T[]>): Parspec<T[]>;
declare function make_optional_parspec<T>(inner_parspec: Parspec<T>): Parspec<T | null>;
export type Parspecs = {
    [parname: string]: Parspec<any>;
};
type ParameterValue<P> = P extends Parspec<infer T> ? ParameterDefault<T> : never;
declare function make_duration_parspec(pars?: {
    min?: Duration;
    max?: Duration;
    default?: ParameterDefault<Duration>;
}): Parspec<Duration>;
declare function make_first_of_parspec<T, S>(a: Parspec<T>, b: Parspec<S>, maybe_default?: ParameterDefault<T | S>): Parspec<T | S>;
export declare const ENV: {
    readonly bool: typeof make_bool_parspec;
    readonly true: Parspec<boolean>;
    readonly false: Parspec<boolean>;
    readonly string: typeof make_string_parspec;
    readonly int: (pars?: {
        min?: number;
        max?: number;
        default?: ParameterDefault<number>;
    }) => Parspec<number>;
    readonly float: (pars?: {
        min?: number;
        max?: number;
        default?: ParameterDefault<number>;
    }) => Parspec<number>;
    readonly enum: typeof make_enum_parspec;
    readonly duration: typeof make_duration_parspec;
    readonly list_of: typeof make_list_parspec;
    readonly custom: <T>(ps: Parspec<T>) => Parspec<T>;
    readonly machine_address: Parspec<MachineAddress>;
    readonly optional: typeof make_optional_parspec;
    readonly first_of: typeof make_first_of_parspec;
};
export type ParameterValues<P extends Parspecs> = {
    [parname in keyof P]: ParameterValue<P[parname]>;
};
export type ReifiedParameterValues<P extends Parspecs> = {
    [parname in keyof P]: P[parname] extends Parspec<infer T> ? T : never;
};
export type ParameterDefaults<P extends Parspecs> = Partial<{
    [parname in keyof P]: P[parname] extends Parspec<infer T> ? ParameterDefault<T> : never;
}>;
export declare function env<P extends Parspecs>(parspecs: P): Promise<ReifiedParameterValues<P>>;
export declare function derive_values<P extends Parspecs>({ parspecs, defaults, machines, }: {
    parspecs: P;
    defaults: ParameterDefaults<P>;
    machines: VM.Any[];
}): Promise<ReifiedParameterValues<P>>;
export {};
