import * as VAPI from "vapi";
type AFDSource = Pick<VAPI.Video.AFD, "ar" | "code"> & ({
    bottom?: number;
    top: number;
    bottomStep?: number;
    topStep?: number;
} | {
    bottom: number;
    top?: number;
    bottomStep?: number;
    topStep?: number;
} | {
    left?: number;
    right: number;
    leftStep?: number;
    rightStep?: number;
} | {
    left: number;
    right?: number;
    leftStep?: number;
    rightStep?: number;
} | {});
export declare class Timestamper {
    private mWatcher;
    private mPrevData;
    constructor(master: VAPI.VM.Any);
    close(): void;
    estimate_timestamp(): number | null;
    get_time(): number | null;
    private initialize;
}
type TimestampingMode = "estimate-continuously" | "fixed-increments";
export declare class MetadataSender {
    private socket;
    readonly dstAddress: string;
    readonly frameRate: VAPI.Video.FrameRate;
    readonly payload: number;
    private mContents;
    readonly port: number;
    readonly timestamper: Timestamper;
    readonly timestampingMode: TimestampingMode;
    readonly timestampOffset: number;
    private seqnr;
    readonly srcAddress: string;
    readonly interlaced: boolean;
    private static s_sockets;
    private static get_socket;
    static open({ dstAddress, port, frameRate, interlaced, payload, contents, timestampingMode, timestamper, timestampOffset, seqnr, srcAddress, }: {
        dstAddress: string;
        port: number;
        frameRate: VAPI.Video.FrameRate;
        contents: AFDSource;
        interlaced: boolean;
        payload: number;
        timestampingMode: TimestampingMode;
        timestamper: Timestamper;
        timestampOffset?: number;
        seqnr?: number;
        srcAddress?: string;
    }): Promise<MetadataSender>;
    private static popcount;
    private static u8to10;
    private static insert;
    private static fillMarkerBuffer;
    private static fillAFDBuffer;
    private nominalFramesPerSecond;
    private t0;
    private packetsSent;
    private interval;
    private markerData;
    private contentData;
    private field;
    private mPrevTimestamp;
    private mRTPCountsPerFieldOrFrame;
    private constructor();
    close(): void;
    media_description(mid: "primary" | "secondary"): string;
    activate(): void;
    deactivate(): void;
    shiftSeqnrBy(delta: number): void;
    setContents(contents: AFDSource): void;
    afdData(): {
        code: number;
        ar: VAPI.Video.AspectRatio;
    } | {
        code: number;
        ar: VAPI.Video.AspectRatio;
        bottom?: number | undefined;
        top: number;
        bottomStep?: number | undefined;
        topStep?: number | undefined;
    } | {
        code: number;
        ar: VAPI.Video.AspectRatio;
        bottom: number;
        top?: number | undefined;
        bottomStep?: number | undefined;
        topStep?: number | undefined;
    } | {
        code: number;
        ar: VAPI.Video.AspectRatio;
        left?: number | undefined;
        right: number;
        leftStep?: number | undefined;
        rightStep?: number | undefined;
    } | {
        code: number;
        ar: VAPI.Video.AspectRatio;
        left: number;
        right?: number | undefined;
        leftStep?: number | undefined;
        rightStep?: number | undefined;
    };
    private sendPacket;
    private updateBuffer;
    private sendFrame;
    private tick;
}
export interface ST291Packet {
    linenr: number;
    column: number;
    did: number;
    sdid: number;
    data: Uint16Array;
    cs: number;
}
export declare class ST291Decoder {
    linenr: number;
    column: number;
    sr: number;
    cnt: number;
    pkt?: ST291Packet;
    res: ST291Packet[];
    constructor(linenr: number, column: number, res: ST291Packet[]);
    push(v: number): void;
}
export declare class ST291Encoder {
    static serialize_tc(pkt: DissectedTimecodePacket): {
        did: number;
        sdid: number;
        udw: Uint8Array;
    };
    static encode(pars: {
        did: number;
        sdid: number;
        udw: Uint8Array;
    }): Uint16Array;
}
export type DissectedTimecodePacket = {
    type: "Timecode";
    hours: number;
    minutes: number;
    seconds: number;
    frames: number;
    tc_validity: boolean;
    process_bit: boolean;
    binary_groups: [number, number, number, number, number, number, number, number];
} & ({
    tc_type: "VITC1" | "VITC2";
    line_select: null | number;
    line_duplication_flag: boolean;
} | {
    tc_type: "LTC";
});
export type DissectedST291Packet = (DissectedTimecodePacket | {
    type: "other";
}) & {
    raw: ST291Packet;
};
export declare function dissect_st291_packet(pkt_291: ST291Packet): DissectedST291Packet;
export {};
