import { AT1101, AT1130, NetworkInterfaces, VM } from "vapi";
import { Duration, Level } from "vscript";
import { RTPInterfaces } from "./rtp_receiver.js";
import { DstAddressFn } from "./rtp_transmitter.js";
export declare function findVirtualIfc(vm: VM.Any, criterion: (vifc: NetworkInterfaces.VirtualInterface, port: AT1101.NetworkInterfaces.Port | AT1130.NetworkInterfaces.Port) => Promise<boolean>): Promise<undefined | NetworkInterfaces.VirtualInterface>;
export declare function getVirtualIfc(vm: VM.Any, criterion: (vifc: NetworkInterfaces.VirtualInterface, port: AT1101.NetworkInterfaces.Port | AT1130.NetworkInterfaces.Port) => Promise<boolean>): Promise<NetworkInterfaces.VirtualInterface>;
export declare function getHostingPort(vifc: NetworkInterfaces.VirtualInterface): Promise<AT1101.NetworkInterfaces.Port | AT1130.NetworkInterfaces.Port>;
export interface LinkInfo {
    desc: string;
    ifcName: string;
    mgmtAddress: string;
}
export declare function getLinkInfo(portOrIfc: AT1101.NetworkInterfaces.Port | AT1130.NetworkInterfaces.Port | NetworkInterfaces.VirtualInterface): Promise<LinkInfo>;
export declare function splitIPv4Address(maybe_addr: string | null): null | {
    address: string;
    port?: number;
};
export interface InterfaceSelectorArgs {
    ipaddr: string;
    brief: string;
    vlan_id: null | number;
}
export type InterfaceSelector = (x: InterfaceSelectorArgs) => Promise<null | "primary" | "secondary">;
export declare function default_interface_selector(pars: {
    vm: VM.Any;
    permit_vlan_tags: boolean;
    swap_interfaces: boolean;
}): InterfaceSelector;
export declare function collect_rtp_interfaces(vm: VM.Any, pars?: {
    interface_selector?: InterfaceSelector;
}): Promise<RTPInterfaces>;
export declare function collect_rtp_interfaces(vm: VM.Any, pars?: {
    swap_interfaces?: boolean;
}): Promise<RTPInterfaces>;
export declare function measure_packet_delay_variation(pars: {
    preexisting_receivers: "bulldoze" | "preserve";
    preexisting_transmitters: "bulldoze" | "preserve";
    transmitting_ifc: NetworkInterfaces.VirtualInterface;
    receiving_ifc: NetworkInterfaces.VirtualInterface;
    num_anc_streams: number;
    num_samples: number;
    error_feedback: (msg: string, level: Level) => void;
    progress?: (ratio_done: number) => void;
    address_schema: DstAddressFn;
}): Promise<{
    relative_packet_delays: Duration[];
    transmission_delays: Array<[value: Duration, error: Duration]>;
}>;
export interface IPRoute {
    dst?: string;
    dst_prefix?: number;
    via: string;
    weight?: number;
}
export interface IPConfig {
    dhcp?: boolean;
    ntpd?: boolean;
    reverse_path_filter?: NetworkInterfaces.ReversePathFilter | null;
    ip_addresses?: Array<[address: string, prefix: number]>;
    routes?: Array<IPRoute>;
}
export declare function reconfigure_ip_addresses(port: AT1130.NetworkInterfaces.Port | AT1101.NetworkInterfaces.Port, config: {
    base?: IPConfig;
    vlans?: Record<number, IPConfig>;
}): Promise<{
    reboot_required: boolean;
}>;
