import * as fs from "fs";
export class PersistentMap {
  filePath;
  m_data = new Map();
  constructor(filePath) {
    this.filePath = filePath;
    if (fs.existsSync(filePath)) {
      this.deserialize();
    }
  }
  async get(key, generator) {
    if (!this.m_data.has(key)) {
      this.m_data.set(key, await generator());
      this.serialize();
    }
    return this.m_data.get(key);
  }
  serialize() {
    try {
      const record = {};
      for (const [key, value] of this.m_data) {
        record[key] = value;
      }
      fs.writeFileSync(this.filePath, JSON.stringify(record));
    } catch (e) {
      throw new Error(`Unable to write map to ${this.filePath}: ${e}`);
    }
  }
  deserialize() {
    try {
      const data = JSON.parse(fs.readFileSync(this.filePath, "utf8"));
      for (const key of Object.keys(data)) {
        this.m_data.set(key, data[key]);
      }
    } catch (e) {
      throw new Error(`Unable to read stored map from ${this.filePath}: ${e}`);
    }
  }
}
